/***************************************************************************
 *
 * knetworkmanager-cellular_device_tray.cpp - A NetworkManager frontend for KDE
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Helmut Schaa       <hschaa@suse.de>, <helmut.schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

/// TQt includes
#include <tqwidget.h> // for TQt::WidgetFlags

// KDE includes
#include <kdebug.h>
#include <tdelocale.h>
#include <kiconloader.h>

// TQt DBus
#include <tqdbusobjectpath.h>


// KNM includes
#include "knetworkmanager-cellular_device_tray.h"
#include "knetworkmanager-cellular_device.h"
#include "knetworkmanager-menuitem.h"
#include "knetworkmanager-menu_subhead.h"
#include "knetworkmanager-connection_store.h"
#include "knetworkmanager-cdma_connection.h"
#include "knetworkmanager-gsm_connection.h"
#include "knetworkmanager-nm_proxy.h"

#include "knetworkmanager-connection_setting_info.h"
#include "knetworkmanager-connection_setting_ipv4.h"
#include "knetworkmanager-connection_setting_cdma.h"
#include "knetworkmanager-connection_setting_gsm.h"
#include "knetworkmanager-connection_settings_dialog.h"

#if !defined(NM_CHECK_VERSION)
#define NM_CHECK_VERSION(x,y,z) 0
#endif

using namespace ConnectionSettings;

class CellularDeviceTrayPrivate
{
	public:
		CellularDeviceTrayPrivate() {}
		~CellularDeviceTrayPrivate() {}

		CellularDevice* dev;
};

void CellularDeviceTray::newConnection()
{
	// create an appropriate connection
	Connection* conn = 0;
	switch (d->dev->getDeviceType()) {
#if NM_CHECK_VERSION(0,8,992)
		case NM_DEVICE_TYPE_MODEM:
#else
		case DEVICE_TYPE_GSM:
#endif
			conn = new GSMConnection();
			break;
#if NM_CHECK_VERSION(0,8,992)
#else
		case DEVICE_TYPE_CDMA:
			conn = new CDMAConnection();
			break;
#endif
		default:
			break;
	}

	// edit the new connection
	ConnectionSettingsDialogImpl* dlg = new ConnectionSettingsDialogImpl(conn, true, NULL, tray(), "connect_something", false, TQt::WDestructiveClose);
	dlg->show();
}


void CellularDeviceTray::addMenuItems(TDEPopupMenu* menu)
{
	ConnectionStore* connectionStore = ConnectionStore::getInstance();

	// device title
	Subhead* subhead = new Subhead (menu, "subhead", d->dev->getInterface(), SmallIcon("nm_device_wwan", TQIconSet::Automatic));
	menu->insertItem (subhead, -1, -1);

	//menu->insertSeparator();
	NMProxy* nm = NMProxy::getInstance();
	Connection* active_conn = nm->getActiveConnection(d->dev);
	if (active_conn)
		kdDebug() << active_conn->getObjectPath().data() << endl;

	// get all available Connections for cellular devices
	// WILLTODO : repeat for GSM
	TQValueList<Connection*> connections = connectionStore->getConnections(NM_SETTING_CDMA_SETTING_NAME);
	for (TQValueList<Connection*>::iterator it = connections.begin(); it != connections.end(); ++it)
	{
		CDMAConnection* cellularconn = dynamic_cast<CDMAConnection*>(*it);
		if (cellularconn)
		{
			// cellular connection found :)
			Info* info = cellularconn->getInfoSetting();
			IPv4* ip = cellularconn->getIPv4Setting();

			// lets create a nice name for this connection
			if (info)
			{
				TQString title = info->getName();
				if (ip)
					title += TQString(" (%1)").arg(ip->getMethod() == IPv4::METHOD_DHCP ? i18n("DHCP") : i18n("Manual IP config"));

				NetworkMenuItem* item = new NetworkMenuItem(d->dev, cellularconn, TQT_TQOBJECT(menu));

				int id = menu->insertItem(title, item, TQT_SLOT(slotActivate()));
				menu->setItemChecked(id, ((*it) == active_conn));
			}
		}
	}
	connections = connectionStore->getConnections(NM_SETTING_GSM_SETTING_NAME);
	for (TQValueList<Connection*>::iterator it = connections.begin(); it != connections.end(); ++it)
	{
		GSMConnection* cellularconn = dynamic_cast<GSMConnection*>(*it);
		if (cellularconn)
		{
			// cellular connection found :)
			Info* info = cellularconn->getInfoSetting();
			IPv4* ip = cellularconn->getIPv4Setting();

			// lets create a nice name for this connection
			if (info)
			{
				TQString title = info->getName();
				if (ip)
					title += TQString(" (%1)").arg(ip->getMethod() == IPv4::METHOD_DHCP ? i18n("DHCP") : i18n("Manual IP config"));

				NetworkMenuItem* item = new NetworkMenuItem(d->dev, cellularconn, TQT_TQOBJECT(menu));

				int id = menu->insertItem(title, item, TQT_SLOT(slotActivate()));
				menu->setItemChecked(id, ((*it) == active_conn));
			}
		}
	}

	// bring the device down
	TDEAction* deactivate = tray()->actionCollection()->action("deactivate_device");
	if (deactivate)
		deactivate->plug(menu);

	menu->insertSeparator();
}

CellularDeviceTray::CellularDeviceTray (CellularDevice* dev, KSystemTray * parent, const char * name)
	: DeviceTrayComponent (dev, parent, name)
{
	d = new CellularDeviceTrayPrivate();
	d->dev = dev;

	setPixmapForState(NM_DEVICE_STATE_ACTIVATED, "nm_device_wwan");
}

CellularDeviceTray::~CellularDeviceTray ()
{
	delete d;
}


#include "knetworkmanager-cellular_device_tray.moc"
