###########################################
#                                         #
#  Improvements and feedback are welcome  #
#                                         #
#  This file is released under GPL >= 3   #
#                                         #
###########################################

# required stuff
find_package( TQt )
find_package( TDE )

tde_setup_architecture_flags( )

include(TestBigEndian)
test_big_endian(WORDS_BIGENDIAN)

tde_setup_largefiles( )


##### check for gcc visibility support

if( WITH_GCC_VISIBILITY )
  tde_setup_gcc_visibility( )
endif( WITH_GCC_VISIBILITY )


##### search for programs

message( STATUS "Checking for ifconfig" )
find_program( PATH_IFCONFIG "ifconfig" DOC "Path for the ifconfig program" )
if( NOT PATH_IFCONFIG )
  tde_message_fatal( "Program ifconfig is required but was not found on your system." )
endif( )
message( STATUS "Checking for ifconfig - found ${PATH_IFCONFIG}" )

message( STATUS "Checking for route" )
find_program( PATH_ROUTE    "route"    DOC "Path for the route program"    )
if( NOT PATH_ROUTE )
  message( STATUS "Checking for route - not found" )
else( )
  message( STATUS "Checking for route - found ${PATH_ROUTE}" )
endif( )

message( STATUS "Checking for iwconfig" )
find_program( PATH_IWCONFIG "iwconfig" DOC "Path for the iwconfig program" )
if( NOT PATH_IWCONFIG )
  message( STATUS "Checking for iwconfig - not found" )
else( )
  message( STATUS "Checking for iwconfig - found ${PATH_IWCONFIG}" )
endif( )


##### support for libiw

if( WITH_LIBIW )
  check_include_file( "iwlib.h" IW_HEADER )
  find_library( IW_LIBRARIES NAMES iw )

  if( IW_HEADER AND IW_LIBRARIES )
    set( HAVE_LIBIW 1 )
    else()
      tde_message_fatal( "libiw support is requested but was not found on your system" )
  endif( IW_HEADER AND IW_LIBRARIES )
endif( WITH_LIBIW )
