/* -*- Mode: C++ -*-
   KDChart - a multi-platform charting engine
   */

/****************************************************************************
 ** Copyright (C) 2001-2003 Klarälvdalens Datakonsult AB.  All rights reserved.
 **
 ** This file is part of the KDChart library.
 **
 ** This file may be distributed and/or modified under the terms of the
 ** GNU General Public License version 2 as published by the Free Software
 ** Foundation and appearing in the file LICENSE.GPL included in the
 ** packaging of this file.
 **
 ** Licensees holding valid commercial KDChart licenses may use this file in
 ** accordance with the KDChart Commercial License Agreement provided with
 ** the Software.
 **
 ** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 ** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 **
 ** See http://www.klaralvdalens-datakonsult.se/?page=products for
 **   information about KDChart Commercial License Agreements.
 **
 ** Contact info@klaralvdalens-datakonsult.se if any conditions of this
 ** licensing are not clear to you.
 **
 **********************************************************************/
#ifndef __KDCHARTGLOBAL_H__
#define __KDCHARTGLOBAL_H__

#include <tqglobal.h>

#include <float.h>

#if defined(unix) || defined(__unix__) || defined(TQ_WS_MAC) || defined(TQ_WS_LINUX)
#include <limits.h>
#else
#define MINDOUBLE DBL_MIN
#define MAXDOUBLE DBL_MAX
#endif

#if defined(_MSC_VER)
#pragma warning(disable: 4251)
#endif
#include <kdchart_export.h>


/* \file KDChartGlobal.h
   \brief Definition of global macros.
   */



#if defined(_MSC_VER)
#ifndef TQT_NO_STL
#define TQT_NO_STL // Avoid a name clash
#endif
#endif



// --- new format since TQt 3.0.0 or since 3.0.4 ???
#ifndef COMPAT_TQT_VERSION
#if defined(_MSC_VER)
#pragma message( "using TQt > 2.3.2" )
#endif
//#define COMPAT_TQT_VERSION [[[TQT_VERSION IS DEPRECATED]]]
#define COMPAT_TQT_VERSION 0x039999
#endif

// since TQt 3.1 they do /not/ include limits.h or climits on windows anymore
// so we must include that manually
#if COMPAT_TQT_VERSION > 0x030099
#if defined(_MSC_VER)
#include <climits>
#endif
#endif


#if COMPAT_TQT_VERSION < 0x030000

#if !defined(Q_ASSERT)
#if defined(TQT_CHECK_STATE)
#if defined(TQT_FATAL_ASSERT)
#define Q_ASSERT(x)  ((x) ? (void)0 : tqFatal("ASSERT: \"%s\" in %s (%d)",#x,__FILE__,__LINE__))
#else
#define Q_ASSERT(x)  ((x) ? (void)0 : tqWarning("ASSERT: \"%s\" in %s (%d)",#x,__FILE__,__LINE__))
#endif
#else
#define Q_ASSERT(x)
#endif
#endif

#if !defined(TQT_NO_COMPAT)
// source compatibility with TQt 2.x
#ifndef Q_OS_TEMP
#  if !defined(ASSERT)
#    define ASSERT(x) Q_ASSERT(x)
#  endif
#endif // Q_OS_TEMP
#endif // TQT_NO_COMPAT

#define TQPtrList TQList
#define TQPtrListIterator TQListIterator
#define TQPtrVector TQVector
#define TQMemArray TQArray

#include <tqlist.h>
#include <tqvector.h>
#include <tqarray.h>

#else

#include <tqptrlist.h>
#include <tqptrvector.h>
#include <tqmemarray.h>

#endif
// end of #if COMPAT_TQT_VERSION < 0x030000



#endif
