/***************************************************************************
                          reportstestcommon.h
                          -------------------
    copyright            : (C) 2002-2005 by Thomas Baumgart
    email                : ipwizard@users.sourceforge.net
                           Ace Jones <ace.j@hotpop.com>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef REPORTSTESTCOMMON_H
#define REPORTSTESTCOMMON_H

#include <tqvaluelist.h>
class TQDomDocument;

#include "../mymoney/mymoneyaccount.h"
#include "../mymoney/mymoneytransaction.h"
#include "../mymoney/mymoneymoney.h"
class MyMoneyReport;

namespace reports {
class PivotTable;
class QueryTable;
}

namespace test {

extern const MyMoneyMoney moCheckingOpen;
extern const MyMoneyMoney moCreditOpen;
extern const MyMoneyMoney moConverterCheckingOpen;
extern const MyMoneyMoney moConverterCreditOpen;
extern const MyMoneyMoney moZero;
extern const MyMoneyMoney moSolo;
extern const MyMoneyMoney moParent1;
extern const MyMoneyMoney moParent2;
extern const MyMoneyMoney moParent;
extern const MyMoneyMoney moChild;
extern const MyMoneyMoney moThomas;
extern const MyMoneyMoney moNoPayee;

extern TQString acAsset;
extern TQString acLiability;
extern TQString acExpense;
extern TQString acIncome;
extern TQString acChecking;
extern TQString acCredit;
extern TQString acSolo;
extern TQString acParent;
extern TQString acChild;
extern TQString acSecondChild;
extern TQString acGrandChild1;
extern TQString acGrandChild2;
extern TQString acForeign;
extern TQString acCanChecking;
extern TQString acJpyChecking;
extern TQString acCanCash;
extern TQString acJpyCash;
extern TQString inBank;
extern TQString eqStock1;
extern TQString eqStock2;
extern TQString acInvestment;
extern TQString acStock1;
extern TQString acStock2;
extern TQString acDividends;
extern TQString acInterest;
extern TQString acTax;
extern TQString acCash;

class TransactionHelper: public MyMoneyTransaction
{
private:
  TQString m_id;
public:
  TransactionHelper( const TQDate& _date, const TQString& _action, MyMoneyMoney _value, const TQString& _accountid, const TQString& _categoryid, const TQString& _currencyid = TQString(), const TQString& _payee="Test Payee" );
  ~TransactionHelper();
  void update(void);
protected:
  TransactionHelper(void) {}
};

class InvTransactionHelper: public TransactionHelper
{
public:
  InvTransactionHelper( const TQDate& _date, const TQString& _action, MyMoneyMoney _shares, MyMoneyMoney _value, const TQString& _stockaccountid, const TQString& _transferid, const TQString& _categoryid );
  void init( const TQDate& _date, const TQString& _action, MyMoneyMoney _shares, MyMoneyMoney _value, const TQString& _stockaccountid, const TQString& _transferid, const TQString& _categoryid );
};

class BudgetEntryHelper
{
private:
  TQDate m_date;
  TQString m_categoryid;
  bool m_applytosub;
  MyMoneyMoney m_amount;

public:
  BudgetEntryHelper( void ): m_applytosub(false) {}
  BudgetEntryHelper( const TQDate& _date, const TQString& _categoryid, bool _applytosub, const MyMoneyMoney& _amount ): m_date(_date), m_categoryid(_categoryid), m_applytosub(_applytosub), m_amount(_amount) {}
};

class BudgetHelper: public TQValueList<BudgetEntryHelper>
{
  MyMoneyMoney budgetAmount( const TQDate& _date, const TQString& _categoryid, bool& _applytosub );
};

extern TQString makeAccount( const TQString& _name, MyMoneyAccount::accountTypeE _type, MyMoneyMoney _balance, const TQDate& _open, const TQString& _parent, TQString _currency="", bool _taxReport = false );
extern void makePrice(const TQString& _currencyid, const TQDate& _date, const MyMoneyMoney& _price );
TQString makeEquity(const TQString& _name, const TQString& _symbol );
extern void makeEquityPrice(const TQString& _id, const TQDate& _date, const MyMoneyMoney& _price );
extern void writeRCFtoXMLDoc( const MyMoneyReport& filter, TQDomDocument* doc );
extern void writeTabletoHTML( const reports::PivotTable& table, const TQString& _filename = TQString() );
extern void writeTabletoHTML( const reports::QueryTable& table, const TQString& _filename = TQString() );
extern void writeTabletoCSV( const reports::PivotTable& table, const TQString& _filename = TQString() );
extern void writeTabletoCSV( const reports::QueryTable& table, const TQString& _filename = TQString() );
extern void writeRCFtoXML( const MyMoneyReport& filter, const TQString& _filename = TQString() );
extern bool readRCFfromXMLDoc( TQValueList<MyMoneyReport>& list, TQDomDocument* doc );
extern bool readRCFfromXML( TQValueList<MyMoneyReport>& list, const TQString& filename );
extern void XMLandback( MyMoneyReport& filter );
extern MyMoneyMoney searchHTML(const TQString& _html, const TQString& _search);

} // end namespace test

#endif // REPORTSTESTCOMMON_H

// vim:cin:si:ai:et:ts=2:sw=2:
