/***************************************************************************
                         kmymoneyaccountbutton  -  description
                            -------------------
   begin                : Mon May 31 2004
   copyright            : (C) 2000-2004 by Michael Edwardes
   email                : mte@users.sourceforge.net
                          Javier Campos Morales <javi_c@users.sourceforge.net>
                          Felix Rodriguez <frodriguez@users.sourceforge.net>
                          John C <thetacoturtle@users.sourceforge.net>
                          Thomas Baumgart <ipwizard@users.sourceforge.net>
                          Kevin Tambascio <ktambascio@users.sourceforge.net>
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// ----------------------------------------------------------------------------
// QT Includes

#include <tqdrawutil.h>
#include <tqpainter.h>
#include <tqstyle.h>
#include <tqapplication.h>

// ----------------------------------------------------------------------------
// KDE Includes

// ----------------------------------------------------------------------------
// Project Includes

#include <kmymoney/mymoneyfile.h>
#include <kmymoney/kmymoneyaccountcombo.h>
#include "kmymoneyaccountcompletion.h"

KMyMoneyAccountCombo::KMyMoneyAccountCombo( TQWidget* parent, const char* name ) :
  KComboBox( parent, name ),
  m_completion(0),
  m_mlbDown(false)
{
#ifndef KMM_DESIGNER
  m_completion = new kMyMoneyAccountCompletion(this);

  connect(this, TQT_SIGNAL(clicked()), this, TQT_SLOT(slotButtonPressed()));
  connect(m_completion, TQT_SIGNAL(itemSelected(const TQString&)), this, TQT_SLOT(slotSelected(const TQString&)));
#endif

  // make sure that we can display a minimum of characters
  TQFontMetrics fm(font());
  setMinimumWidth(fm.maxWidth()*15);
  setMaximumHeight(height());

  // we only use this one item and replace the text as we have our own dropdown box
  insertItem(TQString(""));
}

KMyMoneyAccountCombo::~KMyMoneyAccountCombo()
{
}

void KMyMoneyAccountCombo::slotButtonPressed(void)
{
  m_completion->show();
}

void KMyMoneyAccountCombo::slotSelected(const TQString& id)
{
  try {
    MyMoneyAccount acc = MyMoneyFile::instance()->account(id);
    setText(acc.name());
    emit accountSelected(id);
  } catch(MyMoneyException *e) {
    delete e;
  }
}

void KMyMoneyAccountCombo::setSelected(const TQString& id)
{
  if(!id.isEmpty()) {
    try {
      MyMoneyAccount acc = MyMoneyFile::instance()->account(id);
      setSelected(acc);
    } catch(MyMoneyException *e) {
      tqDebug(TQString("Account '%1' not found in %2(%3)").arg(id).arg(__FILE__).arg(__LINE__));
      delete e;
    }
  } else {
    setText(TQString());
    m_completion->setSelected(id);
  }
}

void KMyMoneyAccountCombo::setSelected(const MyMoneyAccount& acc)
{
  m_completion->setSelected(acc.id());
  setText(acc.name());
}

void KMyMoneyAccountCombo::setText(const TQString& txt)
{
  changeItem(txt, currentItem());
}

int KMyMoneyAccountCombo::loadList(const TQString& baseName, const TQValueList<TQString>& accountIdList, const bool clear)
{
  AccountSet set;

  return set.load(m_completion->selector(), baseName, accountIdList, clear);
}

int KMyMoneyAccountCombo::loadList(KMyMoneyUtils::categoryTypeE typeMask)
{
  AccountSet set;
  TQValueList<int> typeList;

  if(typeMask & KMyMoneyUtils::asset) {
    set.addAccountGroup(MyMoneyAccount::Asset);
  }
  if(typeMask & KMyMoneyUtils::liability) {
    set.addAccountGroup(MyMoneyAccount::Liability);
  }
  if(typeMask & KMyMoneyUtils::income) {
    set.addAccountGroup(MyMoneyAccount::Income);
  }
  if(typeMask & KMyMoneyUtils::expense) {
    set.addAccountGroup(MyMoneyAccount::Expense);
  }

  return set.load(m_completion->selector());
}

int KMyMoneyAccountCombo::loadList(MyMoneyAccount::accountTypeE type)
{
  AccountSet set;

  set.addAccountType(type);

  return set.load(m_completion->selector());
}

void KMyMoneyAccountCombo::keyPressEvent(TQKeyEvent* k)
{
  switch(k->key()) {
    case TQt::Key_Tab:
      break;

    case TQt::Key_Space:
      emit clicked();
      break;

    default:
      break;
  }
  return;
}

void KMyMoneyAccountCombo::mousePressEvent(TQMouseEvent *e)
{
  if ( e->button() != Qt::LeftButton ) {
    e->ignore();
    return;
  }
  bool hit = TQT_TQRECT_OBJECT(rect()).contains( e->pos() );
  if ( hit ) {                                // mouse press on button
    m_mlbDown = TRUE;                         // left mouse button down
    emit pressed();
  }
}

void KMyMoneyAccountCombo::mouseReleaseEvent(TQMouseEvent *e)
{
  if ( e->button() != Qt::LeftButton ) {
      e->ignore();
      return;
  }
  if ( !m_mlbDown )
      return;
  m_mlbDown = FALSE;                            // left mouse button up
  emit released();
  if ( TQT_TQRECT_OBJECT(rect()).contains( e->pos() ) ) {              // mouse release on button
    emit clicked();
  }
}

int KMyMoneyAccountCombo::count(void) const
{
  return m_completion->selector()->accountList().count();
}

TQStringList KMyMoneyAccountCombo::accountList(const TQValueList<MyMoneyAccount::accountTypeE>& list) const
{
  return m_completion->selector()->accountList(list);
};

int KMyMoneyAccountCombo::loadList(const TQValueList<int>& list)
{
  // FIXME make the caller construct the AccountSet directly
  AccountSet set;
  TQValueList<int>::const_iterator it;
  for(it = list.begin(); it != list.end(); ++it) {
    set.addAccountType(static_cast<MyMoneyAccount::accountTypeE>(*it));
  }
  return set.load(m_completion->selector());
};

TQStringList KMyMoneyAccountCombo::selectedAccounts(void) const
{
  TQStringList list;
  m_completion->selector()->selectedItems(list);
  return list;
};

#include "kmymoneyaccountcombo.moc"
