/***************************************************************************
                          kmymoneyplugin.cpp
                             -------------------
    begin                : Wed Jan 5 2005
    copyright            : (C) 2005 Thomas Baumgart
    email                : ipwizard@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// ----------------------------------------------------------------------------
// QT Includes

// ----------------------------------------------------------------------------
// KDE Includes

#include <kinstance.h>
#include <tdeaboutdata.h>
#include <tdeaction.h>

// ----------------------------------------------------------------------------
// Project Includes


#include "kmymoneyplugin.h"

KMyMoneyPlugin::Plugin::Plugin(TQObject* o, const char* name) :
  TQObject(o, name)
{
}

KMyMoneyPlugin::Plugin::~Plugin()
{
}

TDEAction* KMyMoneyPlugin::Plugin::action(const TQString& actionName) const
{
  static TDEShortcut shortcut("");
  static TDEAction dummyAction(TQString("Dummy"), TQString(), shortcut, static_cast<const TQObject*>(this), 0, static_cast<TDEActionCollection*>(0), "");

  TDEAction* p = actionCollection()->action(actionName.latin1());
  if(p)
    return p;

  tqWarning("Action with name '%s' not found!", actionName.latin1());
  return &dummyAction;
}

TDEToggleAction* KMyMoneyPlugin::Plugin::toggleAction(const TQString& actionName) const
{
  static TDEShortcut shortcut("");
  static TDEToggleAction dummyAction(TQString("Dummy"), TQString(), shortcut, static_cast<const TQObject*>(this), 0, static_cast<TDEActionCollection*>(0), "");

  TDEAction* q = actionCollection()->action(actionName.latin1());

  if(q) {
    TDEToggleAction* p = dynamic_cast<TDEToggleAction*>(q);
    if(!p) {
      tqWarning("Action '%s' is not of type TDEToggleAction", actionName.latin1());
      p = &dummyAction;
    }
    return p;
  }

  tqWarning("Action with name '%s' not found!", actionName.latin1());
  return &dummyAction;
}

KMyMoneyPlugin::ViewInterface* KMyMoneyPlugin::Plugin::viewInterface() const
{
  return static_cast<ViewInterface*>( parent()->child( 0, "KMyMoneyPlugin::ViewInterface" ) );
}

KMyMoneyPlugin::StatementInterface* KMyMoneyPlugin::Plugin::statementInterface() const
{
  return static_cast<StatementInterface*>( parent()->child( 0, "KMyMoneyPlugin::StatementInterface" ) );
}

KMyMoneyPlugin::ImportInterface* KMyMoneyPlugin::Plugin::importInterface() const
{
  return static_cast<ImportInterface*>( parent()->child( 0, "KMyMoneyPlugin::ImportInterface" ) );
}

#include "kmymoneyplugin.moc"
