//
// C++ Interface:
//
// Description:
//
//
// Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//

#ifndef KMFPROTOCOLPROPERTIESWIDGET_H
#define KMFPROTOCOLPROPERTIESWIDGET_H

#include "kmyfirewallprotocolpropertieswidget.h"


#include <tqptrlist.h>
#include <tqstring.h>
#include <tqguardedptr.h>
#include <tqpixmap.h>
#include <tquuid.h>

namespace KMF {
class KMFProtocol;
class KMFProtocolUsage;
class KMFProtocolCategory;

class KMFProtocolPropertiesWidget : public KMyFirewallProtocolPropertiesWidget {
		Q_OBJECT
  

	public:
		KMFProtocolPropertiesWidget ( TQWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
		~KMFProtocolPropertiesWidget();
		/*$PUBLIC_FUNCTIONS$*/
		
		void loadProtocolUsage( KMFProtocolUsage* );
		void loadProtocol( KMFProtocol* );
		void loadProtocolCategory( KMFProtocolCategory* );
		
	public slots:
		/*$PUBLIC_SLOTS$*/

	protected:
		/*$PROTECTED_FUNCTIONS$*/
		void blockAllSignals( bool );
		
	protected slots:
		/*$PROTECTED_SLOTS$*/
	void slotEnableProtocolLimit( bool );
	void slotSetProtocolLimitRate( int );
	void slotSetProtocolLimitInterval( const TQString& );
	void slotEnableProtocolLogging( bool );
	void slotProtocolDeleted();

	private:
		TQGuardedPtr<KMFProtocolUsage> m_protocolUsage;
		// TQGuardedPtr<KMFProtocolUsage> m_protocol;
};
}
#endif

