//
// C++ Interface: kmfrulesetdoc
//
// Description: 
//
//
// Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KMFRULESETDOC_H
#define KMFRULESETDOC_H

/**
	@author Christian Hubinger <chubinger@irrsinnig.org>
*/

//QT Includes
#include <tqguardedptr.h>

// KDE includes
#include <kdemacros.h>

namespace KMF {
class KMFTarget;
class KMFNetwork;
class KMFError;

class KDE_EXPORT KMFRulesetDoc{
public:
    KMFRulesetDoc( KMFTarget* );

    virtual ~KMFRulesetDoc();
	KMFTarget* target();
	KMFNetwork* network();
	void setTarget( KMFTarget* );
	
	/** return a TQString containing the documents script to 
		setup the firewall configuration */
	virtual const TQString& compile() = 0;

	/** Writes the shellscrip that contains the iptables commands to settup
		the firewall to file.
		If file = TQString() a SaveAs dialog will popup. */
	KMFError* createFirewallScript( const TQString& fi );

protected:
	 
	 
private:
	KMFRulesetDoc(); 



private: // DATA
	TQGuardedPtr<KMFTarget> m_target;
	
};
}
#endif
