/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/*
Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2001
*/


#ifndef __kmfgenericinterface_part_h__
#define __kmfgenericinterface_part_h__

#include <klibloader.h>
#include <tdeparts/part.h>
#include <tdeparts/factory.h>

class TDEInstance;
class TDEAboutData;
class TQLabel;
class TDEAction;
class TDEActionMenu;

namespace KMF {
class KMFMainWindow;
class KMFGenericInterface;

class KMFGenericInterfacePart: public KParts::ReadWritePart {
	Q_OBJECT
  
public:
	KMFGenericInterfacePart( TQWidget *parent, const char *name, TQObject *parentObject, const
                char *nameOb,
	                         const TQStringList & /*args*/ );
	virtual ~KMFGenericInterfacePart();
	static TDEAboutData *createAboutData();

	/**
	 * This is a virtual function inherited from KParts::ReadWritePart.
	 * A shell will use this to inform this Part if it should act
	 * read-only
	 */
	virtual void setReadWrite( bool rw );

	/**
	 * Reimplemented to disable and enable Save action
	 */
	virtual void setModified( bool modified );
public slots:
	void slotEnableActions( bool );
	void slotGoAccessControl();
	void slotGoMyNetwork();
	void slotGoSpecialHosts();
	void slotGoICMPOptions();
	void slotGoNATConfiguration();
	void slotGoLogging();
	
	void slotTargetChanged();
	
	
	
	
protected:
	/**
	 * This must be implemented by each part
	 */
	virtual bool openFile();

	/**
	 * This must be implemented by each read-write part
	 */
	virtual bool saveFile();

private:
	KMFMainWindow *m_app;
	
	KMFGenericInterface *m_genericinterface;
	TDEAction* m_actionGoMyNetwork;
	TDEAction* m_actionGoAccessControl;
	TDEAction* m_actionGoSpecialHosts;
	TDEAction* m_actionGoICMPOptions;
	TDEAction* m_actionGoNATConfiguration;
	TDEAction* m_actionGoLogging;

/*signals:
	void sigUpdateView();*/
};



class KMFGenericInterfacePartFactory : public KParts::Factory
{
    Q_OBJECT
  
public:
    KMFGenericInterfacePartFactory();
    virtual ~KMFGenericInterfacePartFactory();
    virtual KParts::Part* createPartObject( TQWidget *parentWidget, const char *widgetName,
                                            TQObject *parent, const char *name,
                                            const char *classname, const TQStringList &args );
    static TDEInstance* instance();

private:
    static TDEInstance* s_instance;
    static TDEAboutData* s_about;
};
}
#endif


