//
// C++ Interface:
//
// Description:
//
//
// Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//

#ifndef KMFINTERFACEWIDGET_H
#define KMFINTERFACEWIDGET_H

#include "kmyfirewallinterfacewidget.h"

#include <tqstring.h>

#include <tqguardedptr.h>

class TQStringList;

namespace KMF {
class KMFTarget;

class KMFInterfaceWidget : public KMyFirewallInterfaceWidget {
	Q_OBJECT
  

public:
	KMFInterfaceWidget( TQWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
	~KMFInterfaceWidget();
	/*$PUBLIC_FUNCTIONS$*/
	void addInterface( const TQString& interface );
	void addInterfaces( TQStringList interfaces );
	void clear();
	
	void loadTarget( KMFTarget* target );
	
	TQStringList interfaces();
	
public slots:
	/*$PUBLIC_SLOTS$*/
	void slotDelInterface();
	void slotAddInterface();
	

protected:
	/*$PROTECTED_FUNCTIONS$*/
	void updateView();

protected slots:
	/*$PROTECTED_SLOTS$*/

signals:
		void sigTargetChanged();
		
private: 
	TQGuardedPtr<KMFTarget> m_target;
};
}
#endif

