/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/*
Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2001
*/


#ifndef _KMFINSATLLERPART_H_
#define _KMFINSATLLERPART_H_


#include <tqstring.h>
#include <tdeparts/part.h>
#include <tdeparts/plugin.h>
#include <tdeparts/factory.h>
#include <kxmlgui.h>

// Project Includes
#include "../core/kmfplugin.h"
class TQWidget;
class TQPainter;
class KURL;
class TDEAction;
class TDEActionMenu;
class TDEInstance;

namespace KMF {

class KMFDoc;
class KMFProcOut;
class KMFCompilerInterface;
class KMyFirewall;
class KMFCompilerPlugin;
class KMFTarget;


/**
 * @author Christian Hubinger <chubinger@irrsinnig.org>
 */
class KMFInstallerPlugin : public KMFPlugin {
	Q_OBJECT
  
public:
	/**
	 * Default constructor
	 */
	KMFInstallerPlugin( TQObject *parent, const char *name );

	/**
	 * Destructor
	 */
	virtual ~KMFInstallerPlugin();


			
public slots:
	void slotEnableActions( bool );

public slots:
	void slotStopFirewall();
	void slotStartFirewall();
	void slotShowScript();
	void slotShowConfig();
	void slotShowFilter();
	void slotShowNat();
	void slotShowMangle();
	void slotInstallFW();
	void slotUninstallFW();
	void slotGenerateInstallerPackage();
	
	
private:
// 	bool isLocalTarget();
	bool isConfigValid();
	
	void generateInstallerPackage( KMFTarget* );
	void cmdShowRunningConfig( const TQString& );

private:
	KMFDoc* m_doc;
	TDEAction* m_actionStopFw;
	TDEAction* m_actionRunFw;
	TDEAction* m_actionPreviewScript;
	TDEAction* m_actionShowConfig;
	TDEAction* m_actionShowFilter;
	TDEAction* m_actionShowNat;
	TDEAction* m_actionShowMangle;
	TDEActionMenu* m_actionMenu;
	TDEAction* m_actionInstallFW;
	TDEAction* m_actionUninstallFW;
	TDEAction* m_generateInstallPackage;
	enum { IPT, GENERIC };
	int m_docType;
	KMFProcOut *m_execWidget;
	KMFProcOut* execWidget();
};

class KMFInstallerPluginFactory : public KLibFactory {
	Q_OBJECT
  
public:
	KMFInstallerPluginFactory( TQObject *parent = 0, const char *name = 0 );
	virtual ~KMFInstallerPluginFactory() {
		delete s_instance;
	};
	virtual TQObject* createObject( TQObject* parent = 0, const char* pname = 0,
	                               const char* name = TQOBJECT_OBJECT_NAME_STRING,
	                               const TQStringList &args = TQStringList() );
private:
	static TDEInstance* s_instance;
};
}
#endif // _KMFINSATLLERPART_H_
