/***************************************************************************
 *   Copyright (C) 2004 by Sashmit Bhaduri                                 *
 *   smt@vfemail.net                                                       *
 *                                                                         *
 *   Licensed under GPL.                                                   *
 ***************************************************************************/

#ifndef PAGEVIEWER_H
#define PAGEVIEWER_H

#include <cstdlib>
using std::abs;

#include <tqdatetime.h>
#include <tqstring.h>

#include "viewer.h"


class TDEAction;
class TDEToolBarPopupAction;


namespace KlamAV
{
    
    // taken from KDevelop
    struct PageViewerHistoryEntry
    {
        KURL url;
        TQString title;
        int id;
    
        PageViewerHistoryEntry() {}
        PageViewerHistoryEntry(const KURL& u, const TQString& t=TQString::null): url(u), title(t)
        {
            id = abs( TQTime::currentTime().msecsTo( TQTime() ) );    // nasty, but should provide a reasonably unique number
        }
    };

    // the back/forward navigation was taken from KDevelop. Kudos to the KDevelop team!
    class PageViewer : public Viewer
    {
        Q_OBJECT
        public:
            PageViewer(TQWidget* parent, const char* name);
            
            virtual bool openURL(const KURL &url);

        public slots:
            void slotBack();
            void slotForward();
            void slotReload();
            void slotStop();
            void slotSetCaption(const TQString& cap);
            virtual void slotPaletteOrFontChanged();

        protected:

            void addHistoryEntry(const KURL& url);
            
        protected slots:
            void slotStarted(TDEIO::Job *);
            void slotCompleted();
            void slotCancelled(const TQString &errMsg);
            void slotBackAboutToShow();
            void slotForwardAboutToShow();
            void slotPopupActivated( int id );
            virtual void slotPopupMenu(KXMLGUIClient*, const TQPoint&, const KURL&, const KParts::URLArgs&, KParts::BrowserExtension::PopupFlags, mode_t);
            
            void slotGlobalBookmarkArticle();
            void formClicked(const KURL& url, const KParts::URLArgs& args);

            virtual void slotOpenURLRequest(const KURL& url, const KParts::URLArgs& args);
            
        signals:
            void setTabIcon(const TQPixmap&);

        private:
            TQValueList<PageViewerHistoryEntry> m_history;
            TQValueList<PageViewerHistoryEntry>::Iterator m_current;
            
            TDEToolBarPopupAction* m_backAction;
            TDEToolBarPopupAction* m_forwardAction;
            TDEAction* m_reloadAction;
            TDEAction* m_stopAction;

            bool m_restoring;
            TQString m_caption;
            

    };
}

#endif // PAGEVIEWER_H
