/***************************************************************************
 *   Copyright (C) 2004 by Leonid Zeitlin                                  *
 *   lz@europe.com                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef SINGLEWINDOWWATCHER_H
#define SINGLEWINDOWWATCHER_H

#include "windowwatcher.h"
#include <ntqmap.h>

/**
Watches for changes of active window and keep a group per each window

@author Leonid Zeitlin
*/
class SingleWindowWatcher : public WindowWatcher {
  Q_OBJECT
private:
  struct KBWinInfo {
    int groupno;
    int next_groupno;
  };
  typedef TQMap<WId, KBWinInfo> KBWindowMap;
  KBWindowMap m_window_map;
  KBWindowMap::iterator m_active_window;      
  void addWindowToMap(WId window_id);
protected:
  virtual void windowAdded(WId /* id */) { /* do nothing */ }
  virtual void windowRemoved(WId id);
  virtual void activeWindowChanged(WId id);
public:
  SingleWindowWatcher(KBConfig *kbconf, TQObject *parent = 0, const char *name = 0);
  ~SingleWindowWatcher();
  virtual void changeGroup(int groupno, int next_groupno);
  virtual void reset();
};

#endif
