/* ============================================================
 *
 * This file is a part of kipi-plugins project
 * http://www.kipi-plugins.org
 *
 * Date        : 2003-01-31
 * Description : a kipi plugin to convert Raw file in single 
 *               or batch mode.
 *
 * Copyright (C) 2003-2005 by Renchi Raju <renchi@pooh.tam.uiuc.edu>
 * Copyright (C) 2006-2007 by Gilles Caulier <caulier dot gilles at gmail dot com>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * ============================================================ */

#ifndef PLUGIN_RAWCONVERTER_H
#define PLUGIN_RAWCONVERTER_H

// LibKIPi includes.

#include <libkipi/plugin.h>

class TDEAction;

class Plugin_RawConverter : public KIPI::Plugin
{
    Q_OBJECT
  

public:

    Plugin_RawConverter(TQObject *parent,
                        const char* name,
                        const TQStringList &args);
    ~Plugin_RawConverter();
    
    KIPI::Category category( TDEAction* action ) const;
    virtual void setup( TQWidget* widget );
    
private:

    bool checkBinaries();
    bool isRAWFile(const TQString& filePath);

private slots:

    void slotActivateSingle();
    void slotActivateBatch();

private:

    TDEAction *singleAction_;
    TDEAction *batchAction_;
};

#endif /* PLUGIN_RAWCONVERTER_H */
