/***************************************************************************
                          frmprintwizard.h  -  description
                             -------------------
    begin                : Mon Sep 30 2002
    copyright            : (C) 2002 by Todd Shoemaker
    email                : jtshoe11@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef FRMPRINTWIZARD_H
#define FRMPRINTWIZARD_H

// TQt includes.

#include <tqwidget.h>

// KDE includes.

#include <kprinter.h>

// Local includes.

#include "kpaboutdata.h"
#include "tphoto.h"
#include "frmprintwizardbase.h"

class TQPushButton;
class TDEProcess;

namespace KIPIPrintWizardPlugin
{

class FrmPrintWizardBase;

typedef struct _TPhotoSize {
  TQString label;
  int dpi;
  bool autoRotate;
  TQPtrList<TQRect> layouts;  // first element is page size
} TPhotoSize;

class FrmPrintWizard : public FrmPrintWizardBase  
{
   Q_OBJECT
  

private:

  enum PageSize {
   Unknown = -1,
   Letter  = 0,
   A4,
   A6,
   P10X15,
   P13X18
  };

  enum AvailableCaptions {
    NoCaptions = 0,
    FileNames,
    ExifDateTime,
    Comment,
    Free
  };

  TQPtrList<TPhoto> m_photos;
  TQPtrList<TPhotoSize> m_photoSizes;

  PageSize     m_pageSize;
  TDEProcess    *m_Proc;
  TQString      m_tempPath;

  int          m_currentPreviewPage;
  TQStringList  m_gimpFiles;

  TQPushButton *m_helpButton;

  bool         m_cancelPrinting;

  KIPIPlugins::KPAboutData *m_about;

  void updateCropFrame(TPhoto *, int);
  void setBtnCropEnabled();
  void removeGimpFiles();
  void initPhotoSizes(PageSize pageSize);
  void previewPhotos();
  void printPhotos(TQPtrList<TPhoto> photos, TQPtrList<TQRect> layouts, KPrinter &printer);
  TQStringList printPhotosToFile(TQPtrList<TPhoto> photos, TQString &baseFilename, TPhotoSize *layouts);
  void loadSettings();
  void saveSettings();

  int getPageCount();

  TQString captionFormatter(TPhoto *photo, const TQString& format);
  void printCaption(TQPainter &p, TPhoto*photo, int captionW, int captionH, TQString caption);

  bool paintOnePage(TQPainter &p, TQPtrList<TPhoto> photos, TQPtrList<TQRect> layouts,
                    int captionType, unsigned int &current, bool useThumbnails = false);

  bool paintOnePage(TQImage &p, TQPtrList<TPhoto> photos, TQPtrList<TQRect> layouts,
                    int captionType, unsigned int &current);

  void manageBtnPrintOrder();
  void manageBtnPreviewPage();

public:

  FrmPrintWizard(TQWidget *parent=0, const char *name=0);
  ~FrmPrintWizard();
  void print( KURL::List fileList, TQString tempPath);
  TQRect * getLayout(int photoIndex);

public slots:

  void BtnCropRotate_clicked();
  void BtnCropNext_clicked();
  void BtnCropPrev_clicked();
  void FrmPrintWizardBaseSelected(const TQString &);
  void ListPhotoSizes_selected( TQListBoxItem * );
  void ListPhotoSizes_highlighted ( int );
  void ListPrintOrder_selected( TQListBoxItem * );
  void ListPhotoOrder_highlighted ( int );
  void EditCopies_valueChanged( int );
  void GrpOutputSettings_clicked(int id);
  void EditOutputPath_textChanged(const TQString &);
  void CaptionChanged( int );
  void BtnBrowseOutputPath_clicked();
  void CmbPaperSize_activated( int );

  void BtnPrintOrderUp_clicked();
  void BtnPrintOrderDown_clicked();

  void BtnPreviewPageDown_clicked();
  void BtnPreviewPageUp_clicked();

protected slots:

  void accept();
  void reject();
  void slotHelp();
};

}  // NameSpace KIPIPrintWizardPlugin


#endif // FRMPRINTWIZARD_H

