/* ============================================================
 *
 * This file is a part of kipi-plugins project
 * http://www.kipi-plugins.org
 *
 * Date        : 2005-12-19
 * Description : a plugin to export image collections using SimpleViewer.
 *
 * Copyright (C) 2005-2006 by Joern Ahrens <joern dot ahrens at kdemail dot net>
 * Copyright (C) 2008 by Gilles Caulier <caulier dot gilles at gmail dot com>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * ============================================================ */

#ifndef SVEDIALOG_H
#define SVEDIALOG_H

// Include files for KDE

#include <kdialogbase.h>

// Include files for KIPI

#include <libkipi/interface.h>

// Local includes

#include "kpaboutdata.h"

class TQFrame;
class TQCheckBox;
class TQComboBox;

class KLineEdit;
class KIntNumInput;
class KColorButton;
class KURLRequester;
class TDEConfig;

namespace KIPI
{
    class ImageCollectionSelector;
}

namespace KIPISimpleViewerExportPlugin
{

class SVEDialog : public KDialogBase
{
    Q_OBJECT
  

public:

    SVEDialog( KIPI::Interface* interface, TQWidget *parent=0);
    ~SVEDialog();

    void readConfig();
    void writeConfig();

    void slotOk();
    TQValueList<KIPI::ImageCollection> getSelectedAlbums() const;

    TQString title() const;
    void setTitle(const TQString &title);

    bool resizeExportImages() const;
    void setResizeExportImages(bool resize);

    int imagesExportSize() const;
    void setImagesExportSize(int size);

    int maxImageDimension() const;
    void setMaxImagesDimension(int size);

    bool showExifComments() const;
    void setShowExifComments(bool show);

    int thumbnailRows() const;
    void setThumbnailRows(int rows);

    int thumbnailColumns() const;
    void setThumbnailColumns(int columns);

    int frameWidth() const;
    void setFrameWidth(int width);

    int stagePadding() const;
    void setStagePadding(int stagePadding);

    TQColor textColor() const;
    void setTextColor(const TQColor &color);

    TQColor frameColor() const;
    void setFrameColor(const TQColor &color);

    TQColor backgroundColor() const;
    void setBackgroundColor(const TQColor &color);

    TQString navDirection() const;
    void setNavDirection(const TQString &direction);

    TQString navPosition() const;
    void setNavPosition(const TQString &pos);

    TQString exportURL() const;

private:

    void selectionPage();
    void generalPage();
    void lookPage();

private slots:

    void slotHelp();

private:

    TQFrame                              *m_selectionPage;
    TQFrame                              *m_generalPage;
    TQFrame                              *m_lookPage;

    TQCheckBox                           *m_resizeExportImages;
    TQCheckBox                           *m_showExifComments;
    TQComboBox                           *m_navPosition;
    TQComboBox                           *m_navDirection;

    KLineEdit                           *m_title;
    KIntNumInput                        *m_imagesExportSize;
    KIntNumInput                        *m_maxImageDimension;
    KIntNumInput                        *m_thumbnailRows;
    KIntNumInput                        *m_thumbnailColumns;
    KColorButton                        *m_textColor;
    KColorButton                        *m_backgroundColor;
    KColorButton                        *m_frameColor;
    KIntNumInput                        *m_frameWidth;
    KIntNumInput                        *m_stagePadding;
    KURLRequester                       *m_exportURL;

    KIPI::Interface                     *m_interface;
    KIPI::ImageCollectionSelector       *m_imageCollectionSelector;
    KIPIPlugins::KPAboutData            *m_about;
    TQValueList<KIPI::ImageCollection>    m_selectedAlbums;
};

} // namespace KIPISimpleViewerExportPlugin

#endif /* SVEDIALOG_H */
