/* ============================================================
 *
 * This file is a part of kipi-plugins project
 * http://www.kipi-plugins.org
 *
 * Date        : 2004-10-01
 * Description : a kipi plugin to batch process images
 *
 * Copyright (C) 2004-2007 by Gilles Caulier <caulier dot gilles at gmail dot com>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

#ifndef IMAGEPREVIEW_H
#define IMAGEPREVIEW_H

// Include files for TQt

#include <tqscrollview.h>
#include <tqimage.h>
#include <tqstring.h>

// Include files for KDE

#include <kdialogbase.h>

// Local includes

#include "kpaboutdata.h"

class TQPixmap;
class TQCursor;
class TQLCDNumber;
class TQSlider;
class TQPushButton;

class TDEProcess;

namespace KIPIBatchProcessImagesPlugin
{

/////////////////////////////////////////////////////////////////////////////////////////////////////

class PixmapView : public TQScrollView
{
Q_OBJECT
  

public:

    PixmapView(bool cropAction, TQWidget *parent=0, const char *name=0);
    ~PixmapView();

    void setImage(const TQString &ImagePath, const TQString &tmpPath);
    void resizeImage(int ZoomFactor);

private slots:
    
    void slotPreviewReadStd(TDEProcess* proc, char *buffer, int buflen);
    void PreviewProcessDone(TDEProcess* proc);
    void contentsWheelEvent( TQWheelEvent * e );
    void contentsMousePressEvent ( TQMouseEvent * e );
    void contentsMouseReleaseEvent ( TQMouseEvent * e );
    void contentsMouseMoveEvent( TQMouseEvent * e );

signals:

    void wheelEvent( int delta );

protected:

    TQPixmap     *m_pix;
    
    TQImage       m_img;

    int          m_w;
    int          m_h;
    int          m_xpos;
    int          m_ypos;

    TDEProcess    *m_PreviewProc;

    TQString      m_previewOutput;
    TQString      m_previewFileName;

    bool         m_validPreview;
    bool         m_cropAction;

    TQCursor     *m_handCursor;

    void drawContents(TQPainter *p, int x, int y, int w, int h);
    void PreviewCal(const TQString &ImagePath, const TQString &tmpPath);

};

/////////////////////////////////////////////////////////////////////////////////////////////////////

class ImagePreview : public KDialogBase
{
Q_OBJECT
  

public:
    
    ImagePreview(const TQString &fileOrig, const TQString &fileDest, const TQString &tmpPath,
                 bool cropActionOrig, bool cropActionDest, const TQString &EffectName,
                 const TQString &FileName, TQWidget *parent=0);
    ~ImagePreview();

private slots:
    
    void slotZoomFactorValueChanged( int ZoomFactorValue );
    void slotWheelChanged( int delta );
    void slotHelp(void);
    
protected:
    
    PixmapView  *m_previewOrig;
    PixmapView  *m_previewDest;
    
    TQLCDNumber  *LCDZoomFactorValue;
    
    TQSlider     *ZoomFactorSlider;
    
    TQPushButton *m_helpButton;

private:

    KIPIPlugins::KPAboutData    *m_about;
};

}  // NameSpace KIPIBatchProcessImagesPlugin

#endif  // IMAGEPREVIEW_H

