//////////////////////////////////////////////////////////////////////////////
//
//    KIMG2MPG.H
//
//    Copyright (C) 2003 Gilles Caulier <caulier dot gilles at gmail dot com>
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin Street, Fifth Floor, Cambridge, MA 02110-1301, USA.
//
//////////////////////////////////////////////////////////////////////////////


#ifndef KImg2mpgData_included
#define KImg2mpgData_included

// Include files for TQt

#include <tqstring.h>
#include <tqcolor.h>
#include <tqtimer.h>
#include <tqguardedptr.h>
#include <tqdatetime.h>

// Include files for KDE

#include <kdialog.h>
#include <tdelistbox.h>
#include <kprocess.h>
#include <tdeio/previewjob.h>

// Include files for KIPI

#include "kpaboutdata.h"
#include <libkipi/interface.h>

// Local includes

#include "kimg2mpgbase.h"

class KFileItem;
class TQPushButton;
class TQComboBox;
class TQSpinBox;
class TQGroupBox;
class TQListBoxItem;
class TQLabel;
class TQWidget;
class TQPixmap;

class TDEConfig;
class TDEProcess;
class KLineEdit;
class TDEIconLoader;
class KColorButton;
class TDEListBox;
class KButtonBox;
class KProgress;
class KURL;

namespace KIPIMPEGEncoderPlugin
{

class KShowDebuggingOutput;
class OptionsDialog;

class ListImageItems : public TDEListBox
{
Q_OBJECT
  

public:
    ListImageItems(TQWidget *parent=0, const char *name=0);

signals:
    void addedDropItems(KURL::List filesUrl);

protected:
    void dragEnterEvent(TQDragEnterEvent *e);
    void dropEvent(TQDropEvent *e);
};


class KImg2mpgData : public KImg2mpgBase
{
Q_OBJECT
  

public:

  KImg2mpgData( KIPI::Interface* interface, TQWidget* parent = 0, const char * name = 0 );
  virtual ~KImg2mpgData();

  void show();
  void ShowNumberImages( int Number );
  void closeEvent(TQCloseEvent*);
  TQPixmap LoadIcon( TQString Name, int Group );
  void addItems(const KURL::List& fileList);
  void writeSettings();
  void readSettings();

  OptionsDialog* m_OptionDlg;

public slots:

  void reset();
  void readStderr(TDEProcess *proc, char *buffer, int buflen);
  void EncodeDone(TDEProcess* );
  void slotMPEGFilenameDialog( void );
  void slotAudioFilenameDialog( void );
  void slotImagesFilesButtonAdd( void );
  void slotImagesFilesButtonDelete( void );
  void slotImagesFilesButtonUp( void );
  void slotImagesFilesButtonDown( void );
  void slotEncode( void );
  void slotOptions( void );
  void slotClose( void );
  void slotHelp( void );
  void slotImagesFilesSelected( TQListBoxItem *item );
  void SlotPortfolioDurationChanged ( int );
  void slotOptionDlgOkClicked( void );
  void slotGotPreview(const KFileItem* , const TQPixmap &pixmap);
  void slotFailedPreview(const KFileItem*);
  void slotAddDropItems(KURL::List filesUrl);

private:
  
  TQString               m_VideoFormatConfig;
  TQString               m_VideoTypeConfig;
  TQString               m_ChromaConfig;
  TQString               m_ImageDurationConfig;
  TQString               m_TransitionSpeedConfig;
  TQString               m_MPEGOutputFileConfig;
  TQString               m_AudioInputFileConfig;
  TQString               m_IMBinFolderConfig;
  TQString               m_MJBinFolderConfig;
  TQString               m_TmpFolderConfig;
  TQString               m_NoneLabel;
  TQString               m_EncodeString;
  TQString               m_DebugOuputMessages;
  TQString               m_CommandLine;
  TQString               m_ImagesFilesSort;

  TQColor                m_BackgroundColorConfig;

  TDEConfig*              m_config;

  TDEIO::PreviewJob*      m_thumbJob;

  TQTime                 m_EncodingDuration;
  TQTime                 m_DurationTime;

  bool                  m_Abort;
  bool                  m_Encoding;

  pid_t                 m_Img2mpgPidNum;

  TDEProcess*             m_Proc;

  TDEIconLoader*          m_Icons;

  KIPI::Interface*      m_interface;

  KIPIPlugins::KPAboutData* m_about;

  class KShowDebuggingOutput* m_DebuggingDialog;

  void RemoveTmpFiles( void );
  bool DeleteDir(TQString dirname);
  bool deldir(TQString dirname);
};

}  // NameSpace KIPIMPEGEncoderPlugin

#endif // KImg2mpgData_included
