/* ============================================================
 * File  : gallerywindow.h
 * Author: Renchi Raju <renchi@pooh.tam.uiuc.edu>
 * Date  : 2004-11-30
 * Copyright 2004 by Renchi Raju <renchi@pooh.tam.uiuc.edu>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * ============================================================ */

#ifndef GALLERYWINDOW_H
#define GALLERYWINDOW_H

#include <kdialogbase.h>
#include <tqvaluelist.h>
#include <tqpair.h>
#include <tqintdict.h>

class TQListView;
class TQPushButton;
class TQSpinBox;
class TQCheckBox;
class TQProgressDialog;
class TDEHTMLPart;
class KURL;

namespace KIPI
{
class Interface;
}
namespace KIPIPlugins
{
class KPAboutData;
}

namespace KIPIGalleryExportPlugin
{

class Galleries;
class GalleryTalker;
class GAlbum;
class GPhoto;
class GAlbumViewItem;

class GalleryWindow : public KDialogBase
{
    Q_OBJECT
  

public:

    GalleryWindow(KIPI::Interface *interface, TQWidget *parent, Galleries* pGalleries);
    ~GalleryWindow();

private:

    TQListView                *m_albumView;
    TDEHTMLPart                *m_photoView;
    TQPushButton              *m_newAlbumBtn;
    TQPushButton              *m_addPhotoBtn;
    TQPushButton              *m_helpButton;
    TQCheckBox                *m_resizeCheckBox;
    TQSpinBox                 *m_dimensionSpinBox;
    GalleryTalker            *m_talker;
    TQIntDict<GAlbumViewItem>  m_albumDict;
    TQString                   m_lastSelectedAlbum;
    KIPI::Interface          *m_interface;
    KIPIPlugins::KPAboutData *m_about;

    TQProgressDialog                      *m_progressDlg;
    unsigned int                          m_uploadCount;
    unsigned int                          m_uploadTotal;
    TQValueList< TQPair<TQString,TQString> >  m_uploadQueue;

    Galleries* mpGalleries;
    Gallery*   mpGallery;

private slots:

    void slotDoLogin();
    void slotLoginFailed( const TQString& msg );
    void slotBusy( bool val );
    void slotError( const TQString& msg );
    void slotAlbums( const TQValueList<GAlbum>& albumList );
    void slotPhotos( const TQValueList<GPhoto>& photoList );
    void slotAlbumSelected();
    void slotOpenPhoto( const KURL& url );
    void slotNewAlbum();
    void slotAddPhotos();
    void slotAddPhotoNext();
    void slotAddPhotoSucceeded();
    void slotAddPhotoFailed( const TQString& msg );
    void slotAddPhotoCancel();
    void slotHelp();
};

}

#endif /* GALLERYWINDOW_H */
