/***************************************************************************
 *   Copyright (C) 2007 by Ken Werner                                      *
 *   ken.werner@web.de                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#ifndef UPTIMESRC_H
#define UPTIMESRC_H
#include "labelsource.h"
#include "threadedtrigger.h"
#include <tqfile.h>
#include <list>

/**
 * UptimeSrc reads fan values from /proc/acpi/ibm/thermal
 * which is provided by the ibm-acpi kernel module.
 */
class UptimeSrc : public LabelSource {
	Q_OBJECT
	 //macro which activates signals and slots (moc)
public:
	/**
	 * Creates a new Source from the given File and index
	 */
	UptimeSrc(TQWidget* inParent, const TQFile& inSourceFile);
	virtual ~UptimeSrc();

	/**
	 * Creates instances of that Source (and returns pointers to them)
	 */
	static std::list<Source*> createInstances(TQWidget* inParent);

	/**
	 * Fetches and returns the value of this source
	 * This method is called from a thread so don't call it directly
	 */
	virtual TQString fetchValue();


    /**
     * get the format for the akku time left from i18n.
     */
    virtual void realizeWidget();
private:
	/**
	 * The file from which the value is read
	 */
	TQFile mSourceFile;

    /**
     * the format of the time display. short and long version
     */
    TQString mTimeFormatShort;
    TQString mTimeFormatLong;

	/**
	 * triggers the fetchValue method
	 */
	ThreadedTrigger mTrigger;
};
#endif //UPTIMESRC_H
