/***************************************************************************
 *   Copyright (C) 2007 by Ken Werner                                      *
 *   ken.werner@web.de                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#include "labelsource.h"
#include <tqlabel.h>
#include <kcolorbutton.h>
#include <tdefontrequester.h>
#include <tqcombobox.h>
#include <tqcheckbox.h>
#include <tdelocale.h>

//#include "kdebug.h"

LabelSource::LabelSource(TQWidget* inParent):
		TriggeredSource(inParent),
		mParent(inParent),
		mLabelSourcePrefs(NULL){ 
}

LabelSource::~LabelSource(){
}

TQWidget* LabelSource::getWidget(){
	//kdDebug() << "LabelSource::getWidget called: " << mID << endl;
	return mLabel;
}

void LabelSource::createSubPrefs(TQWidget* inParent){
	if(!mLabelSourcePrefs){
		mLabelSourcePrefs = new LabelSourcePrefs(inParent, "labelsourceprefsui");
		// disable nameCheckBox if taskbarCheckBox is disabled
		connect(mSourcePrefs->taskbarCheckBox, TQT_SIGNAL(toggled(bool)), mLabelSourcePrefs->colorLabel, TQT_SLOT(setEnabled(bool)));
		connect(mSourcePrefs->taskbarCheckBox, TQT_SIGNAL(toggled(bool)), mLabelSourcePrefs->colorButton, TQT_SLOT(setEnabled(bool)));
		connect(mSourcePrefs->taskbarCheckBox, TQT_SIGNAL(toggled(bool)), mLabelSourcePrefs->fontLabel, TQT_SLOT(setEnabled(bool)));
		connect(mSourcePrefs->taskbarCheckBox, TQT_SIGNAL(toggled(bool)), mLabelSourcePrefs->fontRequester, TQT_SLOT(setEnabled(bool)));
		connect(mSourcePrefs->taskbarCheckBox, TQT_SIGNAL(toggled(bool)), mLabelSourcePrefs->alignmentLabel, TQT_SLOT(setEnabled(bool)));
		connect(mSourcePrefs->taskbarCheckBox, TQT_SIGNAL(toggled(bool)), mLabelSourcePrefs->alignmentComboBox, TQT_SLOT(setEnabled(bool)));
		addPrefs(mLabelSourcePrefs);
	}
}

void LabelSource::updatePrefsGUI(){
	TriggeredSource::updatePrefsGUI(); // update prefs of the super class
	mLabelSourcePrefs->colorButton->setColor(mLabel->paletteForegroundColor());
	mLabelSourcePrefs->fontRequester->setFont(mLabel->font());
	switch (mLabel->alignment()) {
		case TQt::AlignCenter:
			mLabelSourcePrefs->alignmentComboBox->setCurrentItem(1);
			break;
		case TQt::AlignRight:
			mLabelSourcePrefs->alignmentComboBox->setCurrentItem(2);
			break;
		default: // TQt::AlignLeft
			break;
			mLabelSourcePrefs->alignmentComboBox->setCurrentItem(0);
	}
}

void LabelSource::setPrefsWidgetsEnabled(bool isEnabled, bool isShownOnApplet){
	TriggeredSource::setPrefsWidgetsEnabled(isEnabled, isShownOnApplet);
	// disable/enable some widgets if source is disabled/enabled	if(isEnabled)
	mLabelSourcePrefs->colorLabel->setEnabled(isEnabled && isShownOnApplet);
	mLabelSourcePrefs->colorButton->setEnabled(isEnabled && isShownOnApplet);
	mLabelSourcePrefs->fontLabel->setEnabled(isEnabled && isShownOnApplet);
	mLabelSourcePrefs->fontRequester->setEnabled(isEnabled && isShownOnApplet);
	mLabelSourcePrefs->alignmentLabel->setEnabled(isEnabled && isShownOnApplet);
	mLabelSourcePrefs->alignmentComboBox->setEnabled(isEnabled && isShownOnApplet);
}

void LabelSource::applyPrefs(){
	TriggeredSource::applyPrefs(); // call apply prefs of the super class
	mLabel->setPaletteForegroundColor(mLabelSourcePrefs->colorButton->color());
	mLabel->setFont(mLabelSourcePrefs->fontRequester->font());
	int alignID = mLabelSourcePrefs->alignmentComboBox->currentItem();
	TQt::AlignmentFlags align = TQt::AlignCenter;
	if(alignID == 0){
		align = TQt::AlignLeft;
	}else if(alignID == 2){
		align = TQt::AlignRight;
	}
	mLabel->setAlignment(align);
	updateLabel(mValue);
}

void LabelSource::savePrefs(TDEConfig* inTDEConfig){
	TriggeredSource::savePrefs(inTDEConfig);
	inTDEConfig->writeEntry(mID + "_color", mLabelSourcePrefs->colorButton->color());
	inTDEConfig->writeEntry(mID + "_font", mLabelSourcePrefs->fontRequester->font());
	inTDEConfig->writeEntry(mID + "_align", mLabel->alignment());
}

void LabelSource::loadPrefs(TDEConfig* inTDEConfig){
	TriggeredSource::loadPrefs(inTDEConfig);
	TQColor color = inTDEConfig->readColorEntry(mID + "_color");
	if(!color.isValid())
		color.setRgb(0,0,0);
	mLabel->setPaletteForegroundColor(color);
	mLabel->setFont(inTDEConfig->readFontEntry(mID + "_font"));
	mLabel->setAlignment(inTDEConfig->readNumEntry(mID + "_align"));
}

void LabelSource::updateLabel(const TQString& inValue){
	// update the label text
	TQString text = (getName().isEmpty() || !showName()) ? inValue : getName() + ": " + inValue;
	//kdDebug() << "updateLabel " << getName() << ", value: " << text << endl;
	//if(mLabel->text() != text)
	mLabel->setText(text);
}

void LabelSource::realizeWidget(){
	Source::realizeWidget();
	// the prefs dialog is created in the addPrefs method
	mLabel = new TQLabel(i18n("n/a"), mParent);
    mLabel->setTextFormat(TQt::PlainText);
	connect(this, TQT_SIGNAL(valueUpdated(const TQString&)), this, TQT_SLOT(updateLabel(const TQString&)));
}
