/***************************************************************************
 *   Copyright (C) 2006 by Ken Werner                                      *
 *   ken.werner@web.de                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#include "ibmhdaps.h"
#include <tqtextstream.h> 
#include <tqdir.h>
#include <tdelocale.h>

IBMHDAPSSrc::IBMHDAPSSrc(TQWidget* inParent, const TQFile& inSourceFile):
		LabelSource(inParent),
		mSourceFile(inSourceFile.name()),
		mTrigger(this){
	mID = "HDAPS" + mSourceFile.name().section( '/', -1, -1, TQString::SectionSkipEmpty ).remove("temp");
	mName = mID;
	mDescription = i18n("This thermal source is provided by the IBM HDAPS driver.");
}

IBMHDAPSSrc::~IBMHDAPSSrc(){
}

std::list<Source*>IBMHDAPSSrc::createInstances(TQWidget* inParent){
	std::list<Source*> list;
	TQDir hdapsDir( "/sys/bus/platform/drivers/hdaps/hdaps" );
	if ( hdapsDir.exists() ){
		hdapsDir.setFilter( TQDir::Files | TQDir::NoSymLinks );
		hdapsDir.setSorting( TQDir::Name);
		for ( unsigned int i = 0; i < hdapsDir.count(); i++ ){
			if(hdapsDir[i].startsWith("temp")){
				TQFile hdapsFile(hdapsDir.canonicalPath() + "/" + hdapsDir[i]);
				list.push_back(new IBMHDAPSSrc(inParent, hdapsFile));
			}
		}
	}
	return list;
}

TQString IBMHDAPSSrc::fetchValue(){
	TQString s = "n/a";
	if(mSourceFile.open(IO_ReadOnly)){
		TQTextStream textStream( &mSourceFile );
		s = textStream.readLine().stripWhiteSpace();
		mSourceFile.close();
		s = formatTemperature(s);
	}
	return s;
}
