/***************************************************************************
                         latexcmd.h
                         ----------
    date                 : Jul 25 2005
    version              : 0.20
    copyright            : (C) 2005 by Holger Danielsson
    email                : holger.danielsson@t-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// kommandos mit weiteren Parametern

#ifndef LATEXCMD_H
#define LATEXCMD_H

#include <tqobject.h>
#include <tqstringlist.h>
#include <tqmap.h>

#include <tdeconfig.h>

class KileInfo;

namespace KileDocument
{

const uint MaxEnvAttr = 8;
const uint MaxCmdAttr = 5;

enum CmdAttribute { 
	CmdAttrNone=0,                                                                      // unknown 
	CmdAttrAmsmath=1,CmdAttrMath=2,CmdAttrList=4,CmdAttrTabular=8,CmdAttrVerbatim=16,   // environments
	CmdAttrLabel=32,CmdAttrReference=64,CmdAttrCitations=128,CmdAttrIncludes=256        // commands
};
                     
class LatexCmdAttributes 
{
public:
	bool standard;
	CmdAttribute type;
	bool starred;
	bool cr;
	bool mathmode;
	bool displaymathmode;
	TQString tabulator;
	TQString option;
	TQString parameter;
};

class LatexCommands : public TQObject
{
	Q_OBJECT
  

public:
	LatexCommands(TDEConfig *config, KileInfo *info);
	~LatexCommands() {};

	TQString envGroupName() { return m_envGroupName; }
	TQString cmdGroupName() { return m_cmdGroupName; }
	TQString configString(LatexCmdAttributes &attr,bool env);
	
	bool isMathEnv(const TQString &name); 
	bool isListEnv(const TQString &name) { return isType(name,'l'); } 
	bool isTabularEnv(const TQString &name) { return isType(name,'t'); } 
	bool isVerbatimEnv(const TQString &name) { return isType(name,'v'); } 
	
	bool isLabelCmd(const TQString &name) { return isType(name,'L'); } 
	bool isReferenceCmd(const TQString &name) { return isType(name,'R'); } 
	bool isCitationCmd(const TQString &name) { return isType(name,'C'); } 
	bool isInputCmd(const TQString &name) { return isType(name,'I'); }

	bool isStarredEnv(const TQString &name);
	bool isCrEnv(const TQString &name);
	bool isMathModeEnv(const TQString &name);
	bool isDisplaymathModeEnv(const TQString &name);
	bool needsMathMode(const TQString &name);
	TQString getTabulator(const TQString &name);
	
	void commandList(TQStringList &list, uint attr, bool userdefined); 
	bool commandAttributes(const TQString &name, LatexCmdAttributes &attr); 
	
	void resetCommands();
		
private:
	
	TDEConfig *m_config;
	KileInfo	*m_ki;
	
	TQString m_envGroupName, m_cmdGroupName;
	TQMap<TQString,TQString> m_latexCommands;
	
	void addUserCommands(const TQString &name, TQStringList &list);
	void insert(const TQStringList &list);
	
	TQString getValue(const TQString &name);
	
	
	bool isUserDefined(const TQString &name);
	bool isType(const TQString &name, TQChar ch);
	TQString getAttrAt(const TQString &name, uint index);
	TQChar getAttrChar(CmdAttribute attr);
	CmdAttribute getCharAttr(TQChar ch);

};




}

#endif
