/*
 * This file is part of the KFTPGrabber project
 *
 * Copyright (C) 2003-2004 by the KFTPGrabber developers
 * Copyright (C) 2003-2004 Jernej Kos <kostko@jweb-network.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * is provided AS IS, WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, and
 * NON-INFRINGEMENT.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Steet, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 * In addition, as a special exception, the copyright holders give
 * permission to link the code of portions of this program with the
 * OpenSSL library under certain conditions as described in each
 * individual source file, and distribute linked combinations
 * including the two.
 * You must obey the GNU General Public License in all respects
 * for all of the code used other than OpenSSL.  If you modify
 * file(s) with this exception, you may extend this exception to your
 * version of the file(s), but you are not obligated to do so.  If you
 * do not wish to do so, delete this exception statement from your
 * version.  If you delete this exception statement from all source
 * files in the program, then also delete it here.
 */

#ifndef KFTPBOOKMARKS_H
#define KFTPBOOKMARKS_H

#include <ntqstring.h>
#include <ntqdom.h>
#include <ntqvaluelist.h>
#include <ntqcache.h>

#include <tdepopupmenu.h>
#include <tdeaction.h>
#include <kurl.h>

namespace KFTPEngine {
  class Thread;
}

namespace KFTPWidgets {
namespace Bookmarks {
  class ListView;
  class ListViewItem;
}
}

#define KFTP_BOOKMARKS_VERSION 2

namespace KFTPBookmarks {

enum SiteType {
  ST_SITE,
  ST_CATEGORY
};

class Site {
friend class Manager;
public:
    Site(TQDomNode node);
    ~Site();
    
    void reparentSite(Site *site);
    
    Site *addSite(TQDomNode node = TQDomNode());
    void addCategory(const TQString &name);
    
    KURL getUrl();
    Site *getParentSite();
    
    Site *duplicate();
    
    TQString getProperty(const TQString &name);
    int getIntProperty(const TQString &name);
    
    void setProperty(const TQString &name, const TQString &value);
    void setProperty(const TQString &name, int value);
    
    void setAttribute(const TQString &name, const TQString &value);
    TQString getAttribute(const TQString &name);
    
    SiteType type() { return m_type; }   
    TQString id() { return m_id; }
private:
    SiteType m_type;
    TQString m_id;
    TQDomElement m_element;
};

class Manager : public TQObject {
Q_OBJECT
public:
    static Manager *self();
    Manager();
    Manager(const Manager &bookmarks);
    ~Manager();
    
    void setBookmarks(KFTPBookmarks::Manager *bookmarks);
    void importSites(TQDomNode node);
    
    void load(const TQString &filename);
    void save();
    
    Site *findSite(const TQString &id);
    Site *findSite(const KURL &url) KDE_DEPRECATED;
    
    Site *findCategory(const TQString &id);
    
    Site *addSite(Site *category, TQDomNode node);
    void delSite(Site *site);
    
    void setupClient(Site *site, KFTPEngine::Thread *client);
    
    void guiPopulateBookmarksMenu(TDEActionMenu *parentMenu, TQDomNode parentNode = TQDomNode(), bool base = true, TQObject *data = 0);
    void guiPopulateBookmarksTree(KFTPWidgets::Bookmarks::ListView *tree, TQDomNode parent = TQDomNode(), KFTPWidgets::Bookmarks::ListViewItem *item = 0);
    void guiPopulateZeroconfMenu(TDEActionMenu *parentMenu);
    void guiPopulateWalletMenu(TDEActionMenu *parentMenu);
    
    void emitUpdate() { emit update(); }
protected:
    static Manager *m_self;
private:
    TQCache<Site> m_siteCache;
    TQDomDocument m_document;
    
    TQCString m_decryptKey;
    TQString m_filename;
    
    TQDomNode findSiteElementByUrl(const KURL &url, TQDomNode parent = TQDomNode());
    TQDomNode findSiteElementById(const TQString &id, TQDomNode parent = TQDomNode());
    TQDomNode findCategoryElementById(const TQString &id, TQDomNode parent = TQDomNode());
    
    // Validation
    void validate(TQDomNode node = TQDomNode());
    
    // XML conversion methods
    void versionUpdate();
    void versionFrom1Update(TQDomNode parent = TQDomNode());
private slots:
    void slotBookmarkExecuted();
    void slotZeroconfExecuted();
    void slotWalletExecuted();
signals:
    void update();
};

}

#endif
