/*
 * This file is part of the KFTPGrabber project
 *
 * Copyright (C) 2003-2004 by the KFTPGrabber developers
 * Copyright (C) 2003-2004 Jernej Kos <kostko@jweb-network.net>
 * Copyright (C) 2004 Markus Brueffer <markus@brueffer.de>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * is provided AS IS, WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, and
 * NON-INFRINGEMENT.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Steet, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 * In addition, as a special exception, the copyright holders give
 * permission to link the code of portions of this program with the
 * OpenSSL library under certain conditions as described in each
 * individual source file, and distribute linked combinations
 * including the two.
 * You must obey the GNU General Public License in all respects
 * for all of the code used other than OpenSSL.  If you modify
 * file(s) with this exception, you may extend this exception to your
 * version of the file(s), but you are not obligated to do so.  If you
 * do not wish to do so, delete this exception statement from your
 * version.  If you delete this exception statement from all source
 * files in the program, then also delete it here.
 */

#ifndef KFTPWIDGETSQUICKCONNECT_H
#define KFTPWIDGETSQUICKCONNECT_H

#include "kftpquickconnectlayout.h"

#include <ntqmap.h>

#include <kdialogbase.h>
#include <kurl.h>

namespace KFTPEngine {
  class Thread;
}

namespace KFTPWidgets {

namespace Bookmarks {
  class BookmarkEditorTLS;
}

/**
 * @author Jernej Kos
 */
class QuickConnectDialog : public KDialogBase
{
Q_OBJECT
public:
    QuickConnectDialog(TQWidget *parent = 0, const char *name = 0);
    ~QuickConnectDialog();
    
    /**
     * Get URL the user is trying to connect to.
     *
     * @return a KURL representing the destination server
     */
    KURL getUrl() { return m_url; }
    
    /**
     * Get the currently selected file transfer protocol.
     *
     * @return index of currently selected protocol
     */
    int getFTPMode();
    
    /**
     * Get the currently set TLS operation mode.
     *
     * @return currently set TLS operation mode
     */
    TQChar getTLSMode();
    
    /**
     * Is the "use custom X509 certificate" checked or not.
     *
     * @return true if the "use custom X509 certificate" is checked
     */
    bool isCertChecked();
    
    /**
     * Get the currently set X509 certificate path.
     *
     * @return path to the user's X509 certificate for this connection
     */
    TQString getCertPath();

    /**
     * Set the destination server's hostname.
     *
     * @param host destination server's hostname
     */
    void setHost(const TQString &host);
    
    /**
     * Set the destination server's port.
     *
     * @param port destination server's port
     */
    void setPort(int port);
    
    /**
     * Focus the dialog's username input field.
     */
    void setFocusToUser();
    
    /**
     * Configures the client acoording to the settings chosen in the quick connect
     * dialog.
     *
     * @param client a disconnected client socket
     */
    void setupClient(KFTPEngine::Thread *client);
private:
    enum ServerProtocol {
      SP_FTP = 0,
      SP_SSL_EXPLICIT,
      SP_SSL_IMPLICIT,
      SP_SFTP
    };
    
    KFTPQuickConnectLayout *m_layout;

    bool m_noUrlChange;
    KURL m_url;
    Bookmarks::BookmarkEditorTLS *m_protocolAdvancedDialog;

    bool m_portChanged;
    
    TQMap<int, KURL> m_recentSites;
private slots:
    virtual void slotOk();

    void slotUrlChanged(const TQString &);
    void slotHostChanged(const TQString&);
    void slotPortChanged(int);
    void slotUserChanged();
    void slotPassChanged();
    void slotAnonClicked();
    void slotProtocolChanged(int);
    void slotProtoAdvancedClicked();
    void slotRecentConnectionActivated(int index);
    void slotClearRecentClicked();
};

}

#endif
