/***************************************************************************
 *   Copyright (C) 2013 by Timothy Pearson                                 *
 *   kb9vqf@pearsoncomputing.net                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <cstdlib>

#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <pwd.h>

#include <tdeapplication.h>
#include <tdestartupinfo.h>
#include <tdecmdlineargs.h>
#include <kuniqueapplication.h>
#include <tdeaboutdata.h>
#include <tdefileitem.h>

#include <ksimpleconfig.h>

#include <tqdatetime.h>
#include <tqfile.h>

#include <libtdeldap.h>

// FIXME
// Connect this to CMake/Automake
#define KDE_CONFDIR "/etc/trinity"

static const char description[] =
	I18N_NOOP("TDE utility for managing workstations in a Kerberos realm");

static const char version[] = "v0.0.1";

static const TDECmdLineOptions options[] =
{
	{ "adminusername <username>", I18N_NOOP("Specifies the username of the administrative user with permissions to perform the requested task"), 0 },
	{ "adminpasswordfile <password file>", I18N_NOOP("Specifies the location of a file which contains the password of the administrative user"), 0 },
	{ "!+command", I18N_NOOP("The command to execute on the Kerberos realm.  Valid commands are: bond unbond disable"), 0 },
	{ "!+realm", I18N_NOOP("The Kerberos realm on which to execute the specified command.  Example: MY.REALM"), 0 },
	{ "", I18N_NOOP("This utility requires an administrative user and password to be specified on the command line to function!"), 0 },
	TDECmdLineLastOption // End of options.
};

int main(int argc, char *argv[])
{
	TDEAboutData aboutData( "tdeldapbonding", I18N_NOOP("Kerberos Realm Bonding Manager"),
		version, description, TDEAboutData::License_GPL,
		"(c) 2013, Timothy Pearson");
		aboutData.addAuthor("Timothy Pearson",0, "kb9vqf@pearsoncomputing.net");
	TDECmdLineArgs::init(argc, argv, &aboutData);
 	TDECmdLineArgs::addCmdLineOptions(options);
	KUniqueApplication::addCmdLineOptions();
	TDEApplication::disableAutoDcopRegistration();

	TDEApplication app(false, false);

	TDEStartupInfo::appStarted();

	KSimpleConfig systemconfig( TQString::fromLatin1( KDE_CONFDIR "/ldap/ldapconfigrc" ));
	systemconfig.setFileWriteMode(S_IRUSR | S_IWUSR | S_IRGRP | S_IROTH);

	//======================================================================================================================================================
	//
	// Manager code follows
	//
	//======================================================================================================================================================

	TDECmdLineArgs *args = TDECmdLineArgs::parsedArgs();
	if (args->count() > 1) {
		int retcode;

		TQString command = TQString(args->arg(0));
		TQString realm = TQString(args->arg(1));

		systemconfig.setGroup("LDAPRealm-" + realm);
		TQString host = systemconfig.readEntry("admin_server");
		LDAPCredentials credentials;
		if (args->isSet("adminusername") && args->isSet("adminpasswordfile")) {
			TQString passFileName = args->getOption("adminpasswordfile");
			TQFile passFile(passFileName);
			if (!passFile.open(IO_ReadOnly)) {
				printf("[ERROR] Unable to open specified password file '%s'\n", passFileName.ascii()); fflush(stdout);
				return -1;
			}
			TQTextStream stream(&passFile);
			credentials.username = args->getOption("adminusername");
			credentials.password = stream.readLine().utf8();
			passFile.close();
		}
		else {
			credentials.use_gssapi = true;
		}
		credentials.realm = realm;
		LDAPManager ldapmanager(realm, host, &credentials);

// FIXME
// Move core bonding functionality from ldapbonding.cpp into libtdeldap, then ***properly*** activate this code!
// 		if (command == "bond") {
// 			// FIXME
// 			LDAPRealmConfig realmConfig;
// 			TQString errorString;
// 
// 			realmConfig.name = realm;
// 			realmConfig.bonded = ;
// 			realmConfig.uid_offset;
// 			realmConfig.gid_offset;
// 			realmConfig.domain_mappings;
// 			realmConfig.kdc;
// 			realmConfig.kdc_port;
// 			realmConfig.admin_server;
// 			realmConfig.admin_server_port;
// 			realmConfig.pkinit_require_eku;
// 			realmConfig.pkinit_require_krbtgt_otherName;
// 			realmConfig.win2k_pkinit;
// 			realmConfig.win2k_pkinit_require_binding;
// 
// 			if (LDAPManager::bondRealm(realmConfig, credentials.username, credentials.password, credentials.realm, &errorString) == 0) {
// 				// Success!
// 			}
// 			else {
// 				// Failure
// 				return -1;
// 			}
// 		}
// 		else if (command == "unbond") {
// 			// FIXME
// 			TQString errorString;
// 
// 			if (LDAPManager::unbondRealm(realm, credentials.username, credentials.password, credentials.realm, &errorString) == 0) {
// 				// Success!
// 			}
// 			else {
// 				// Failure
// 				return -1;
// 			}
// 		}
// 		else if (command == "disable") {
// 			// FIXME
// 		}
// 		else {
			TDECmdLineArgs::usage(i18n("An invalid command was specified"));
			return -1;
// 		}
	}
	else {
		if (args->count() > 0) {
			TDECmdLineArgs::usage(i18n("No Kerberos realm was specified"));
			return -1;
		}
		else {
			TDECmdLineArgs::usage(i18n("No command was specified"));
			return -1;
		}
	}

	//======================================================================================================================================================

	return 0;
}
