/***************************************************************************
 *   Copyright (C) 2006 by Stephen Leaf                                    *
 *   smileaf@smileaf.org                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

/* Adapted for use in the Trinity Desktop Environment */


#ifndef _AUTOSTART_H_
#define _AUTOSTART_H_

#include <tdecmodule.h>
#include <tdeaboutdata.h>
#include <kpushbutton.h>
#include <tdelistview.h>
#include <tdefileitem.h>
#include <tdeglobalsettings.h>
#include <tqpushbutton.h>
#include <tqcombobox.h>

class autostart: public TDECModule
{
  Q_OBJECT

public:
  autostart( TQWidget *parent=0, const char *name=0, const TQStringList& = TQStringList() );
  ~autostart();

  virtual void load();
  virtual void save();
  virtual void defaults();
  virtual int buttons();
  virtual TQString quickHelp() const;
  virtual const TDEAboutData *aboutData() const
  { return myAboutData; };

public slots:
  void addCMD();
  void removeCMD();
  void editCMD(TQListViewItem*);
  bool editCMD(KFileItem);
  void editCMD();
  void setStartOn(int);
  void selectionChanged(TQListViewItem*);

private:
  TDEAboutData *myAboutData;
  TDEGlobalSettings *kgs;
    KPushButton* btnAdd;
    TDEListView* listCMD;
    KPushButton* btnRemove;
    TQPushButton* btnProperties;
  TQComboBox* cmbStartOn;
};

#endif
