/***************************************************************************
 *   Copyright (C) 2004-2009 by Thomas Fischer                             *
 *   fischer@unix-ag.uni-kl.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef KBIBTEXWEBQUERYGOOGLESCHOLAR_H
#define KBIBTEXWEBQUERYGOOGLESCHOLAR_H

#include <tqstringlist.h>
#include <tqbuffer.h>

#include <kurl.h>

#include "fileimporterbibtex.h"
#include "webquery.h"

namespace KBibTeX
{
    /**
     @author Thomas Fischer <fischer@unix-ag.uni-kl.de>
    */
    class WebQueryGoogleScholarWidget : public WebQueryWidget
    {
        Q_OBJECT
    public:
        WebQueryGoogleScholarWidget( TQWidget *parent, const char *name = 0 );
    };

    /**
     @author Thomas Fischer <fischer@unix-ag.uni-kl.de>
    */
    class WebQueryGoogleScholar : public WebQuery
    {
        Q_OBJECT
    public:
        WebQueryGoogleScholar( TQWidget* parent );
        virtual ~WebQueryGoogleScholar();

        void query();

        TQString title();
        TQString disclaimer();
        TQString disclaimerURL();

        WebQueryWidget *widget();

    protected:
        void cancelQuery();

    private slots:
        void slotData( TDEIO::Job *, const TQByteArray &data )
        {
            m_transferJobBuffer->writeBlock( data.data(), data.size() );
        };

        /** Google Scholar's start page has been loaded */
        void slotFinishedStartpage( TDEIO::Job *job );
        /** Settings page has been loaded */
        void slotFinishedLoadingSettings( TDEIO::Job *job );
        /** Settings page upload and search mask loaded */
        void slotFinishedSavingSettings( TDEIO::Job *job );
        /** page with results loaded */
        void slotFinishedReceivingResultOverview( TDEIO::Job *job );

    private:
        WebQueryGoogleScholarWidget *m_widget;

        bool m_abort;
        TQString m_searchTerm;
        int m_numberOfResults;
        BibTeX::FileImporterBibTeX *m_importer;
        bool m_originalEnableCookies;
        bool m_originalSessionCookies;
        TQMap <TQString, TQString> m_originalCookieMap;
        TQString m_originalCookieGlobalAdvice;

        TDEIO::TransferJob *m_transferJob;
        TQBuffer *m_transferJobBuffer;

        /** load KDE's cookie configuration, store values, and reset with Google-friendly values */
        void readAndChangeConfig();
        /** restore previous configuration values by saving old cookie configuration */
        void restoreConfig();

        /** extract text from a TQBuffer object */
        TQString textFromBuffer( TQBuffer *buffer );

        /** parse HTML code and get all key-value pairs from <input..> and <select><option ...></select> */
        TQMap <TQString, TQString> evalFormFields( const TQString &htmlCode );

        /** glue together URL from key-value pairs in form */
        TQString formFieldsToUrl( const TQString &prefix, const TQMap<TQString, TQString> &keyValues );
    };

}

#endif
