/***************************************************************************
 *   Copyright (C) 2004-2009 by Thomas Fischer                             *
 *   fischer@unix-ag.uni-kl.de                                             *
 *                                                                         *
 *   based on code from or inspired by                                     *
 *   - Tellico by Robby Stephenson                                         *
 *   - kbib by Thach Nguyen                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 *                                                                         *
 *                                                                         *
 *   This code is based on code from Tellico 1.2.10                        *
 *                      by Robby Stephenson <robby@periapsis.org>          *
 *   Tellico is released under the GNU GPL 2, too.                         *
 *                      http://www.periapsis.org/tellico/                  *
 ***************************************************************************/
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifndef KBIBTEXWEBQUERYZ3950_H
#define KBIBTEXWEBQUERYZ3950_H

#include <ntqevent.h>
#include <ntqdeepcopy.h>
#include <ntqthread.h>

#include <ksharedptr.h>

#include <fileimporter.h>
#include <webquery.h>
#include <xsltransform.h>
#include <z3950connection.h>

class KComboBox;

namespace KBibTeX
{

    /**
     @author Thomas Fischer <fischer@unix-ag.uni-kl.de>
    */
    class WebQueryZ3950Widget : public WebQueryWidget
    {
        Q_OBJECT
    public:
        WebQueryZ3950Widget( TQWidget *parent, const char *name = 0 );

        KComboBox *comboBoxServers;
        KComboBox *comboBoxInAttribute;
        KComboBox *comboBoxBooleanOp;
        KLineEdit *lineEditQuery2;
        KComboBox *comboBoxInAttribute2;

    protected:
        virtual void init();

    private:
        static const TQString attributesI18N[];
    };


    /**
     @author Thomas Fischer <fischer@unix-ag.uni-kl.de>
    */
    class WebQueryZ3950 : public WebQuery
    {
        Q_OBJECT
    public:
        WebQueryZ3950( TQWidget* parent );
        virtual ~WebQueryZ3950();

        void query();

        TQString title();
        TQString disclaimer();
        TQString disclaimerURL();

        WebQueryWidget *widget();

    private:
        WebQueryZ3950Widget *m_widget;

    protected:
        void cancelQuery();

    protected:
        virtual void customEvent( TQCustomEvent* event );

#ifdef HAVE_YAZ
    private:
        BibTeX::XSLTransform *m_marc21transformer;
        BibTeX::XSLTransform *m_unimarctransformer;
        BibTeX::FileImporter *m_modsImporter;
        KBibTeX::Z3950Connection *m_conn;
        bool m_started;
        bool m_waitingRetrieveRange;
        TQString m_syntax;
        TQStringList m_modsList;
        int m_hitCounter;

        void storeResult( const TQString& resultText, const TQString& syntax );
        void evalStoredResults();
        TQString queryClause( const TQString& text, int field );
#endif // HAVE_YAZ
    };
}

#endif
