/***************************************************************************
 *   Copyright (C) 2004-2009 by Thomas Fischer                             *
 *   fischer@unix-ag.uni-kl.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef KBIBTEXWEBQUERYARXIV_H
#define KBIBTEXWEBQUERYARXIV_H

#include <ntqstring.h>
#include <ntqstringlist.h>
#include <ntqregexp.h>

#include <tdeio/job.h>

#include <fileimporterbibtex.h>
#include <webquery.h>

class TQBuffer;

namespace KBibTeX
{
    /**
     @author Thomas Fischer <fischer@unix-ag.uni-kl.de>
    */
    class WebQueryArXivWidget : public WebQueryWidget
    {
        Q_OBJECT
    public:
        WebQueryArXivWidget( TQWidget *parent, const char *name = 0 );
    };

    /**
     @author Thomas Fischer <fischer@unix-ag.uni-kl.de>
    */
    class WebQueryArXiv : public WebQuery
    {
        Q_OBJECT
    public:
        WebQueryArXiv( TQWidget* parent );
        virtual ~WebQueryArXiv();

        void query();

        TQString title();
        TQString disclaimer();
        TQString disclaimerURL();

        WebQueryWidget *widget();

        void fetchFromAbstract( const KURL &abstractURL );

    protected:
        void cancelQuery();

    private slots:
        void arXivResult( TDEIO::Job *job );
        void unlockJob( TDEIO::Job *job );
        void arXivAbstractResult( TDEIO::Job *job );

    private:
        TQString m_lastHit;
        BibTeX::FileImporterBibTeX *m_importer;
        TQString m_arXivServer;
        int m_numberOfResults, m_totalHits, m_receivedHits;
        TQMutex m_currentJobMutex;
        TQValueList<KURL> m_urls;
        WebQueryArXivWidget *m_widget;

        TQRegExp m_jourRef1, m_jourRef2, m_jourRef3, m_jourRef4, m_jourRef5, m_jourRef6, m_reJour, m_reYear, m_rePages;
    };
}

#endif
