/***************************************************************************
*   Copyright (C) 2004-2006 by Thomas Fischer                             *
*   fischer@unix-ag.uni-kl.de                                             *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/
#ifndef KBIBTEXSETTINGSKEYWORD_H
#define KBIBTEXSETTINGSKEYWORD_H

#include <ntqwidget.h>

class TDEListView;
class TQPushButton;

namespace KBibTeX
{

    /**
     @author Thomas Fischer <fischer@unix-ag.uni-kl.de>
    */
    class SettingsKeyword : public TQWidget
    {
        Q_OBJECT
    public:
        SettingsKeyword( TQWidget *parent = 0, const char *name = 0 );
        ~SettingsKeyword();

        void applyData();
        void readData();

    signals:
        void configChanged();

    private slots:
        void slotNewKeyword();
        void slotEditKeyword();
        void slotDeleteKeyword();
        void slotImportKeywords();
        void slotItemRenamed( TQListViewItem * );
        void updateGUI();

    private:
        TQStringList *m_keywords;
        TQStringList m_keywordsFromFile;
        TDEListView *m_listKeywords;
        TQPushButton *m_buttonNewKeyword;
        TQPushButton *m_buttonEditKeyword;
        TQPushButton *m_buttonDeleteKeyword;
        TQPushButton *m_buttonImportKeywords;
        TQString m_oldText;

        void setupGUI();
    };
}

#endif
