/***************************************************************************
*   Copyright (C) 2004-2006 by Thomas Fischer                             *
*   fischer@unix-ag.uni-kl.de                                             *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/
#ifndef SETTINGS_H
#define SETTINGS_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <ntqstringlist.h>

#include <kcompletion.h>

#include <file.h>
#include <fieldlineedit.h>
#include <fileexporterbibtex.h>
#include <fileexporterexternal.h>
#include <entryfield.h>
#include <entry.h>

class TDEConfig;
class TDEStandardDirs;
class KURL;
class TQString;
class TQRegExp;
class TQChar;
class TQFont;

namespace KBibTeX
{
    class Settings
    {
    public:
        struct SearchURL
        {
            TQString description;
            TQString url;
            bool includeAuthor;
        };

        struct UserDefinedInputFields
        {
            TQString name;
            TQString label;
            FieldLineEdit::InputType inputType;
        };

        static Settings* self( BibTeX::File *bibtexFile = NULL );

        void load( TDEConfig * config );
        void save( TDEConfig * config );

        static TQString fieldTypeToI18NString( const BibTeX::EntryField::FieldType fieldType );
        static TQString entryTypeToI18NString( const BibTeX::Entry::EntryType entryType );

        static KURL doiURL( const TQString& doiText );
        static bool kpsewhich( const TQString& filename );
        static KURL locateFile( const TQString& filename, const TQString& bibTeXFileName = TQString::null, TQWidget *window = NULL );
        KURL locateFile( const TQString& filename, TQWidget *window = NULL );
        static TQString resolveLink( const TQString& originalFilename, const TQString& linkFilename );
        static bool openUrl( const KURL& url, TQWidget *parent );

#ifdef HAVE_YAZ
        void z3950clearAll();
        void z3950loadDefault();
        void z3950loadUser( TDEConfig * config );
        void z3950saveUser( TDEConfig *config );
        typedef struct Z3950Server_
        {
            TQString charset, database, host, locale, name, syntax, user, password;
            int port;
        } Z3950Server;
        TQMap<TQString, Z3950Server> z3950_ServerList;
#endif // HAVE_YAZ

        enum DragAction {COPYREFERENCE = 1, COPYBIBTEX = 2};

        // FileIO section
        TQString fileIO_Encoding;
        TQString fileIO_ExportLanguage;
        TQString fileIO_ExportBibliographyStyle;
        TQChar fileIO_BibtexStringOpenDelimiter;
        TQChar fileIO_BibtexStringCloseDelimiter;
        BibTeX::FileExporterBibTeX::KeywordCasing fileIO_KeywordCasing;
        BibTeX::FileExporterExternal::Exporter fileIO_ExporterHTML;
        bool fileIO_EmbedFiles;
        bool fileIO_EnclosingCurlyBrackets;
        bool fileIO_useBibUtils;
        TQString fileIO_bib2db5BasePath;
        TQString fileIO_bib2db5ClassPath;
        int fileIO_NumberOfBackups;

        bool updateBib2Db5ClassPath( const TQString& newBasePath, bool testOnly = false );

        // Editing section
        bool editing_SearchBarClearField;
        bool editing_EnableAllFields;
        int editing_MainListDoubleClickAction;
        int editing_MainListSortingColumn;
        int editing_MainListSortingOrder;
        TQStringList editing_FilterHistory;
        bool editing_ShowMacros;
        bool editing_ShowComments;
        TQValueList<int> editing_MainListColumnsWidth;
        TQValueList<int> editing_MainListColumnsIndex;
        TQValueList<int> editing_HorSplitterSizes;
        TQValueList<int> editing_VertSplitterSizes;
        TQFont editing_SpecialFont;
        bool editing_UseSpecialFont;
        bool editing_FirstNameFirst;
        TQStringList editing_DocumentSearchPaths;
        DragAction editing_DragAction;
        int editing_findDuplicatesSensitivity;

        // SearchURLs section
        TQValueList<SearchURL*> searchURLs;

        // UserDefinedInputFields section
        TQValueList<UserDefinedInputFields*> userDefinedInputFields;

        // External section
        TQString external_XSLTStylesheetHTML;
        bool external_bibconvAvailable;
        bool external_bibtex2htmlAvailable;
        bool external_bib2xhtmlAvailable;
        bool external_latex2rtfAvailable;
        bool external_xml2bibAvailable;
        bool external_end2xmlAvailable;
        bool external_ris2xmlAvailable;

        // Id Suggestions
        TQStringList idSuggestions_formatStrList;
        int idSuggestions_default;
        bool idSuggestions_forceDefault;
        TQStringList idSuggestions_smallWords;

        // Auto-completion for user fields (non-persistant)
        void addToCompletion( BibTeX::File *file );
        void addToCompletion( BibTeX::Element *element );
        void addToCompletion( BibTeX::Value *value, BibTeX::EntryField::FieldType fieldType );
        TDECompletion* completion( BibTeX::EntryField::FieldType fieldType );
        TDECompletion* completionMacro;

        // Keyword list
        TQStringList keyword_GlobalList;

        // Online Database Search;
        int webQuery_LastEngine;
        TQString webQuery_LastSearchTerm;
        int webQuery_LastNumberOfResults;
        bool webQuery_ImportAll;

        // Current BibTeX file
        BibTeX::File *currentBibTeXFile;

        void restoreDefaultSearchURLs();

        TQString detectLyXInPipe();

        // web query history/default values
        TQString getWebQueryDefault( const TQString &key );
        void setWebQueryDefault( const TQString &key, const TQString& value );

        // characters that do match this regexp are
        // not allowed in entry ids or macro keys
        static const TQRegExp noIdChars;

        /** Create backup of file as specified in fileIO_NumberOfBackups */
        bool createBackup( const KURL &url, TQWidget *window = NULL );

    private:
        static Settings* staticSettings;
        TDECompletion **m_completion;
        static TQStringList m_lyxRcFileNames;

        TQMap<TQString, TQString> m_webQueryDefaults;

        Settings();
        ~Settings();

        bool checkExternalToolAvailable( const TQString &binary );
        void checkExternalToolsAvailable();

        int completionFieldTypeToIndex( BibTeX::EntryField::FieldType fieldType );
    };
}

#endif
