/***************************************************************************
*   Copyright (C) 2004-2006 by Thomas Fischer                             *
*   fischer@unix-ag.uni-kl.de                                             *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/
#ifndef BIBTEXMACRO_H
#define BIBTEXMACRO_H

#include <element.h>
#include <entryfield.h>
#include <value.h>

class TQString;

namespace BibTeX
{
    class Macro : public Element
    {
    public:
        Macro( const TQString &key );
        Macro( Macro *other );
        virtual ~Macro();

        void setKey( const TQString &key );
        TQString key() const;

        Value *value() const;
        void setValue( Value *value );

        bool containsPattern( const TQString& pattern, EntryField::FieldType fieldType = EntryField::ftUnknown, FilterType filterType = BibTeX::Element::ftExact, bool caseSensitive = FALSE ) const;

        Element* clone();
        void copyFrom( Macro *other );
        TQString text() const;

    private:
        TQString m_key;
        Value *m_value;
    };

}

#endif
