/***************************************************************************
*   Copyright (C) 2004-2006 by Thomas Fischer                             *
*   fischer@unix-ag.uni-kl.de                                             *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/

#ifndef _KBIBTEXPART_H_
#define _KBIBTEXPART_H_

#include <tdeparts/part.h>
#include <tdeparts/factory.h>

#include <element.h>
#include <xsltransform.h>
#include <documentwidget.h>
#include <settingsdlg.h>

class TQWidget;
class TQTextEdit;
class TQFile;
class TQLabel;
class TQTabWidget;
class TQPainter;
class TQListViewItem;
class TQProgressDialog;
class KURL;
class TDEListView;
class TDEAction;
class TDEActionMenu;
class TDEToggleAction;
class TDEMainWindow;

class KBibTeXPart : public KParts::ReadWritePart
{
    Q_OBJECT

public:
    KBibTeXPart( TQWidget *parentWidget, const char *widgetName,
                 TQObject *parent, const char *name );

    virtual ~KBibTeXPart();

    void setReadWrite( bool rw );

    void setModified( bool modified );

    bool saveAs();
    bool queryClose();
    virtual bool closeURL();

public slots:
    virtual bool save();

signals:
    void signalAddRecentURL( const KURL& );

protected:
    virtual bool openFile();
    virtual bool saveFile();

protected slots:
    void slotFileSaveAs();
    void slotFileMerge();
    void slotFileExport();
    void slotFileStatistics();
    void slotFileFindDups();
    void slotPreferences();

private slots:
    bool slotNewElement();
    void slotSearchWebsites( int id );
    void slotToggleShowSpecialElements();
    void slotDeferredInitialization();
    void slotUpdateMenu( int numSelectedItems );
    void slotUndoChanged( bool undoAvailable );
    void slotUseInPipe();

private:
    enum SearchDirection
    {
        sdForward, sdBackward
    };
    enum SaveStatus
    {
        ssSave, ssExport, ssFailed
    };

    int m_defInitCounter;
    TQLabel *m_preview;
    TQProgressDialog *m_progressDialog;
    KBibTeX::DocumentWidget *m_documentWidget;
    KBibTeX::SettingsDlg *m_settingsDlg;
    TDEAction *m_actionFileMerge;
    TDEAction *m_actionFileExport;
    TDEAction *m_actionFileStatistics;
    TDEAction *m_actionFileFindDups;
    TDEAction *m_actionEditUndo;
    TDEAction *m_actionElementSendToLyX;
    TDEAction *m_actionEditElement;
    TDEAction *m_actionDeleteElement;
    TDEAction *m_actionEditCut;
    TDEAction *m_actionEditCopy;
    TDEAction *m_actionEditCopyRef;
    TDEAction *m_actionEditPaste;
    TDEAction *m_actionEditSelectAll;
    TDEAction *m_actionEditFind;
    TDEAction *m_actionEditFindNext;
    TDEAction *m_actionPreferences;
    TDEAction *m_actionSearchOnlineDatabases;
    TDEActionMenu *m_actionViewDocument;
    TDEAction *m_actionViewFirstDocument;
    TDEAction *m_actionViewDocumentOnlineRef;
    TDEActionMenu *m_actionAssignKeywords;
    TDEAction *m_actionNormalizeIds;
    TDEActionMenu *m_actionMenuSearchWebsites;
    TDEActionMenu *m_actionViewShowColumns;
    TDEAction *m_actionSearchNCBI;
    TDEToggleAction *m_actionUseInPipe;
    TDEToggleAction *m_actionShowComments;
    TDEToggleAction *m_actionShowMacros;
    TDEMainWindow *m_mainWindow;
    TQValueList<KBibTeX::WebQuery*> webQueryList;
    bool m_initializationDone;
    TQFile *m_inPipe;

    void readSettings();
    void writeSettings();

    void setupGUI( TQWidget *parentWidget, const char *name );
    void setupActions();

signals:
    void progressCancel();
};

class TDEInstance;
class TDEAboutData;

class KBibTeXPartFactory : public KParts::Factory
{
    Q_OBJECT
public:
    KBibTeXPartFactory();
    virtual ~KBibTeXPartFactory();
    virtual KParts::Part* createPartObject( TQWidget * parentWidget, const char * widgetName,
                                            TQObject * parent, const char * name,
                                            const char * classname, const TQStringList & /* args */ );
    static TDEInstance* instance();

private:
    static TDEInstance* s_instance;
    static TDEAboutData* s_about;
};

#endif // _KBIBTEXPART_H_
