/***************************************************************************
 *   Copyright (C) 2004-2009 by Thomas Fischer                             *
 *   fischer@unix-ag.uni-kl.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef KBIBTEXIDSUGGESTIONSWIDGET_H
#define KBIBTEXIDSUGGESTIONSWIDGET_H

#include <ntqwidget.h>
#include <ntqdialog.h>

class TQCheckBox;
class TQScrollView;
class TQSpinBox;
class KComboBox;
class KLineEdit;
class KPushButton;

namespace KBibTeX
{
    class IdSuggestionComponent: public TQFrame
    {
        Q_OBJECT
    public:
        IdSuggestionComponent( const TQString& title, TQWidget *parent );
        virtual TQString text() const = 0;
        void setEnableUpDown( bool enableUp, bool enableDown );

    signals:
        void modified();
        void moved();
        void deleted();

    protected:
        TQWidget *moveWidgets( TQWidget *parent );

        bool m_toBeDeleted;
        TQString m_title;
        TQWidget *m_parent;
        KPushButton *m_pushButtonDel;
        KPushButton *m_pushButtonUp;
        KPushButton *m_pushButtonDown;

    protected slots:
        void slotUp();
        void slotDown();
        void slotDelete();
    };

    class IdSuggestionComponentAuthor: public IdSuggestionComponent
    {
    public:
        IdSuggestionComponentAuthor( const TQString &text, TQWidget *parent );
        TQString text() const;
    protected:
        KComboBox *m_comboBoxWhichAuthors;
        KComboBox *m_comboBoxCasing;
        KLineEdit *m_lineEditInBetween;
        TQSpinBox *m_spinBoxLen;
    };

    class IdSuggestionComponentTitle: public IdSuggestionComponent
    {
    public:
        IdSuggestionComponentTitle( const TQString &text, TQWidget *parent );
        TQString text() const;
    protected:
        TQCheckBox *m_checkBoxRemoveSmallWords;
        KComboBox *m_comboBoxCasing;
        KLineEdit *m_lineEditInBetween;
        TQSpinBox *m_spinBoxLen;
    };

    class IdSuggestionComponentYear: public IdSuggestionComponent
    {
    public:
        IdSuggestionComponentYear( const TQString &text, TQWidget *parent );
        TQString text() const;
    protected:
        KComboBox *m_comboBoxDigits;
    };

    class IdSuggestionComponentText: public IdSuggestionComponent
    {
    public:
        IdSuggestionComponentText( const TQString &text, TQWidget *parent );
        TQString text() const;
    protected:
        KLineEdit *m_lineEditInBetween;
    };

    class IdSuggestionsScrollView : public TQScrollView
    {
        Q_OBJECT
    public:
        IdSuggestionsScrollView( TQWidget *parent, const char*name = NULL );
        ~IdSuggestionsScrollView();

        void setMainWidget( TQWidget *widget ) {m_widget = widget;}

    protected:
        void viewportResizeEvent( TQResizeEvent * );

    private:
        TQWidget *m_widget;
    };

    /**
     @author Thomas Fischer <fischer@unix-ag.uni-kl.de>
    */
    class IdSuggestionsWidget : public TQWidget
    {
        Q_OBJECT
    public:
        ~IdSuggestionsWidget();
        int numComponents();

        static TQDialog::DialogCode execute( TQString &formatStr, TQWidget *parent = 0, const char *name = 0 );

    protected:
        IdSuggestionsWidget( const TQString &formatStr, KDialogBase *parent, const char *name = 0 );

        TQString m_originalFormatStr;
        int m_componentCount;

        void reset( const TQString& formatStr );
        void apply( TQString& formatStr );

    private:
        static TQString exampleBibTeXEntry;
        BibTeX::Entry *m_example;
        IdSuggestionsScrollView *m_scrollViewComponents;
        TQLabel *m_labelExample;
        TQWidget *m_listOfComponents;
        KPushButton *m_pushButtonAdd;
        KDialogBase *m_parent;

        void setupGUI();

    private slots:
        void addMenuActivated( int id );
        void updateGUI();
        void componentDeleted();
        void updateExample();
    };

}

#endif
