/***************************************************************************
 *   Copyright (C) 2004-2009 by Thomas Fischer                             *
 *   fischer@unix-ag.uni-kl.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef KBIBTEXIDSUGGESTIONS_H
#define KBIBTEXIDSUGGESTIONS_H

#include <ntqstringlist.h>

#include <file.h>
#include <entry.h>

namespace KBibTeX
{
    struct IdSuggestionTokenInfo
    {
        unsigned int len;
        bool toLower;
        bool toUpper;
        TQString inBetween;
    };

    /**
     @author Thomas Fischer <fischer@unix-ag.uni-kl.de>
    */
    class IdSuggestions
    {
    public:
        static TQStringList createSuggestions( BibTeX::File *file, BibTeX::Entry *entry );
        static TQString createDefaultSuggestion( BibTeX::File *file, BibTeX::Entry *entry );
        static TQString formatStrToHuman( const TQString& formatStr );
        static struct IdSuggestionTokenInfo evalToken( const TQString& token );
        static TQString formatId( BibTeX::Entry *entry, const TQString& formatStr );
        static TQString resolveConflict( BibTeX::File *file, const TQString &id, BibTeX::Element *element = NULL );

        static const TQStringList smallWords;

    private:
        enum Authors {aAll, aOnlyFirst, aNotFirst};

        static const TQRegExp unwantedChars;
        static const TQChar asciiizeSource[];
        static const TQString asciiizeTarget[];

        IdSuggestions();
        ~IdSuggestions();

        static TQStringList authorsLastName( BibTeX::Entry *entry );
        static TQString normalizeText( const TQString& text );
        static TQString asciiizeText( const TQString& text );
        static int extractYear( BibTeX::Entry *entry );
        static TQString extractTitle( BibTeX::Entry *entry );
        static TQString translateToken( BibTeX::Entry *entry, const TQString& token );
        static TQString translateAuthorsToken( BibTeX::Entry *entry, const TQString& token, Authors selectAuthors );
        static TQString translateTitleToken( BibTeX::Entry *entry, const TQString& token, bool removeSmallWords );
    };

}

#endif
