/***************************************************************************
 *   Copyright (C) 2004-2009 by Thomas Fischer                             *
 *   fischer@unix-ag.uni-kl.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef BIBTEXFILEIMPORTBIBUTILS_H
#define BIBTEXFILEIMPORTBIBUTILS_H

#include <file.h>
#include <fileimporter.h>
#include <fileimporterbibtex.h>

class TQBuffer;

namespace BibTeX
{

    /**
     @author Thomas Fischer <fischer@unix-ag.uni-kl.de>
    */
    class FileImporterBibUtils : public FileImporter
    {
        Q_OBJECT
    public:
        FileImporterBibUtils( BibTeX::File::FileFormat inputFormat );
        ~FileImporterBibUtils();

        File* load( TQIODevice *iodevice );
        static bool guessCanDecode( const TQString & text );
        static File::FileFormat guessInputFormat( const TQString &text );

    public slots:
        void cancel();

    private:
        bool m_cancelFlag;
        TQString m_workingDir;
        BibTeX::File::FileFormat m_inputFormat;
        FileImporterBibTeX *m_bibTeXImporter;

        bool m_waiting;
        TQProcess *m_process;
        TQBuffer *m_processBuffer;

        bool iodeviceToXMLbuffer( TQIODevice *iodevice );
        File* xmlBufferToBibTeXFile();
        TQString createTempDir();
        void deleteTempDir( const TQString& directory );

    private slots:
        void wakeUp();
        void slotReadyStdout();
        void slotReadyStderr();
    };

}

#endif // BIBTEXFILEIMPORTBIBUTILS_H
