/***************************************************************************
*   Copyright (C) 2004-2006 by Thomas Fischer                             *
*   fischer@unix-ag.uni-kl.de                                             *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/
#ifndef KBIBTEXENTRYWIDGETKEYWORD_H
#define KBIBTEXENTRYWIDGETKEYWORD_H

#include <entrywidgettab.h>

class TQPushButton;
class TDEListView;

namespace KBibTeX
{
    class KeywordListViewItem: public TQCheckListItem
    {
    public:
        KeywordListViewItem( TDEListView * parent, const TQString & text, bool isGlobal );
        ~KeywordListViewItem();

        bool isGlobal()
        {
            return m_isGlobal;
        };
        void setGlobal( bool global );

    protected:
        bool m_isGlobal;
    };

    /**
     @author Thomas Fischer <fischer@unix-ag.uni-kl.de>
    */
    class EntryWidgetKeyword : public EntryWidgetTab
    {
        Q_OBJECT
    public:
        EntryWidgetKeyword( BibTeX::File *bibtexfile, bool isReadOnly, TQWidget *parent = 0, const char *name = 0 );
        ~EntryWidgetKeyword();

        bool isModified();

    public slots:
        void updateGUI( BibTeX::Entry::EntryType entryType, bool enableAll );
        void apply( BibTeX::Entry *entry );
        void reset( BibTeX::Entry *entry );
        void updateWarnings( BibTeX::Entry::EntryType entryType, TQListView *listViewWarnings );

    private slots:
        void slotSelectionChanged();
        void slotKeywordRenamed( TQListViewItem * item, const TQString & text, int col );
        void slotNewKeyword();
        void slotEditKeyword();
        void slotToggleGlobal();

    private:
        BibTeX::File *m_bibtexfile;
        TQStringList m_availableKeywords;
        TQStringList m_globalKeywords;
        TQStringList m_fileKeywords;
        TQStringList m_usedKeywords;
        bool m_isModified;
        TDEListView *m_listviewKeywords;
        TQPushButton *m_buttonNew;
        TQPushButton *m_buttonEdit;
        TQPushButton *m_buttonToggleGlobal;
        int m_numKeywords;
        TQString m_beforeRenaming;

        void setupGUI();
        void setListView();
        void readListView();
        bool editKeywords( TQStringList *keywords );
    };

}

#endif
