/***************************************************************************
*   Copyright (C) 2004-2006 by Thomas Fischer                             *
*   fischer@unix-ag.uni-kl.de                                             *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/
#ifndef KBIBTEXDOCUMENTWIDGET_H
#define KBIBTEXDOCUMENTWIDGET_H

#include <ntqtabwidget.h>

#include <kdirwatch.h>

#include <fileimporter.h>
#include <file.h>
#include <settings.h>

class TQIODevice;
class TQProgressDialog;
class TQListViewItem;
class TQWidget;
class TQSplitter;

class TDEPopupMenu;
class TDEActionMenu;
class KURL;
class KTextEdit;
class KLineEdit;

namespace KBibTeX
{
    class DocumentListView;
    class DocumentListViewItem;
    class DocumentSourceView;
    class SearchBar;
    class SideBar;
    class WebQuery;

    class DocumentWidget : public TQTabWidget
    {
        Q_OBJECT
    public:
        DocumentWidget( bool isReadOnly, TQWidget *parent = 0, const char *name = 0 );
        ~DocumentWidget();

        bool open( const TQString &fileName, bool mergeOnly = FALSE );
        bool open( TQIODevice *iodevice, bool mergeOnly = FALSE, const TQString &label = TQString::null, BibTeX::FileImporter *importer = NULL );
        bool save( const TQString &fileName, TQStringList *errorLog = NULL );
        bool save( TQIODevice *iodevice, BibTeX::File::FileFormat format = BibTeX::File::formatBibTeX, const TQString &label = TQString::null, TQStringList *errorLog = NULL );

        bool newElement( const TQString& elementType );
        void searchWebsites( const TQString& searchURL, bool includeAuthor );
        void updateViews();
        void showStatistics();

        void setFactory( KXMLGUIFactory *factory, KXMLGUIClient *client );
        void updateViewDocumentMenu( );
        void updateAssignKeywords( );

        void deferredInitialization();
        void saveState();
        void restoreState();

        KDirWatch &dirWatch();

    signals:
        void modified();
        void listViewSelectionChanged( int numSelected );
        void undoChanged( bool undoAvailable );

    public slots:
        void executeElement( DocumentListViewItem* );
        bool editElement();
        bool editElement( DocumentListViewItem* );
        bool editElement( BibTeX::Element* );
        void deleteElements();
        void sendSelectedToLyx();
        void cutElements();
        void copyElements();
        void copyRefElements();
        void pasteElements();
        void selectAll();
        void setReadOnly( bool isReadOnly );
        void configureEditor();
        void undoEditor();
        void find();
        void findNext();
        void refreshBibTeXFile();
        void onlineSearch();
        void findDuplicates();
        void slotViewFirstDocument();
        void slotViewFirstDocumentsOnlineRef();
        void slotNormalizeIds();

    private:
        enum EditMode
        {
            emList, emSource
        };

        KLineEdit *m_lineEditNewKeyword;
        bool m_isReadOnly;
        TQSplitter *m_horSplitter;
        TQSplitter *m_vertSplitter;
        TQWidget *m_container;
        SearchBar *m_searchBar;
        DocumentListView *m_listViewElements;
        KTextEdit * m_preview;
        DocumentSourceView *m_sourceView;
        SideBar* m_sideBar;
        BibTeX::File *m_bibtexfile;
        TQString m_filename;
        TQProgressDialog *m_progressDialog;
        int m_newElementCounter;
        EditMode m_editMode;
        TDEActionMenu *m_viewDocumentActionMenu;
        TDEActionMenu *m_assignKeywordsActionMenu;
        TQStringList m_viewDocumentActionMenuURLs;
        TQMap<int, TQString> m_assignKeywordsActionMenuURLs;
        TDEActionMenu *m_searchWebsitesActionMenu;
        TDEAction *m_actionEditCut;
        TDEAction *m_actionEditCopy;
        TDEAction *m_actionEditCopyRef;
        TDEAction *m_actionEditPaste;
        TDEAction *m_actionEditSelectAll;
        TDEAction *m_actionEditFind;
        TDEAction *m_actionEditFindNext;
        TDEAction *m_actionNormalizeIds;
        KDirWatch m_dirWatch;

        void setupGUI();

        void startProgress( const TQString &label, TQObject *progressFrom );
        void endProgress( TQObject *progressFrom );

        void searchWebsites( BibTeX::Element *element, const TQString& searchURL, bool includeAuthor );

        bool editElementDialog( BibTeX::Element *element );
        void updateFromGUI();
        TQString nextNewEntry();

        KURL::List getEntryURLs( BibTeX::Entry *entry );

        BibTeX::FileImporter *fileImporterFactory( const TQString &fileName );

    private slots:
        void slotShowProgress( int current, int total );
        void slotSelectionChanged();
        void slotPreviewElement( TQListViewItem * item = NULL );
        void slotTabChanged( TQWidget *tab );
        void slotModified();
        void slotFileGotDirty( const TQString& path );
        void slotRefreshDirtyFile();
        void slotViewDocument( int id );
        void slotAssignKeywords( int id );
        void slotAddKeyword();
    };

}

#endif
