/***************************************************************************
 *   Copyright (C) 2004-2009 by Thomas Fischer                             *
 *   fischer@unix-ag.uni-kl.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "webquerymathscinet.h"

#include <ntqlayout.h>
#include <ntqlabel.h>
#include <ntqregexp.h>
#include <ntqspinbox.h>

#include <kpushbutton.h>
#include <tdelocale.h>
#include <kiconloader.h>
#include <kurl.h>
#include <kdebug.h>
#include <tdeio/netaccess.h>
#include <tdemessagebox.h>

#include <settings.h>

namespace KBibTeX
{
    WebQueryMathSciNetWidget::WebQueryMathSciNetWidget( TQWidget *parent, const char *name )
            : WebQueryWidget( parent, name )
    {
        init();

        Settings *settings = Settings::self();
        TQString value = settings->getWebQueryDefault( "MathSciNet" );
        value = value == TQString::null ? "" : value;
        lineEditQuery->setText( value );
        slotTextChanged( value, true );
    }

    void WebQueryMathSciNetWidget::init()
    {
        TQVBoxLayout *vLayout = new TQVBoxLayout( this, 0, KDialog::spacingHint() );

        TQHBoxLayout *hLayout = new TQHBoxLayout( );
        vLayout->addLayout( hLayout );

        KPushButton *clearSearchText = new KPushButton( this );
        clearSearchText->setIconSet( TQIconSet( SmallIcon( "locationbar_erase" ) ) );
        hLayout->addWidget( clearSearchText );
        TQLabel *label = new TQLabel( i18n( "Search &term:" ), this );
        hLayout->addWidget( label );
        lineEditQuery = new KLineEdit( this );
        hLayout->addWidget( lineEditQuery );
        label->setBuddy( lineEditQuery );
        hLayout->addSpacing( KDialog::spacingHint() * 2 );
        connect( clearSearchText, SIGNAL( clicked() ), lineEditQuery, SLOT( clear() ) );
        connect( lineEditQuery, SIGNAL( textChanged( const TQString& ) ), this, SLOT( slotTextChanged( const TQString& ) ) );
        hLayout->setStretchFactor( lineEditQuery, 4 );
        TDECompletion *completionQuery = lineEditQuery->completionObject();

/*
        label = new TQLabel( i18n( "&Number of results:" ), this );
        hLayout->addWidget( label );
        spinBoxMaxHits = new TQSpinBox( 1, 250, 1, this );
        spinBoxMaxHits->setValue( 10 );
        hLayout->addWidget( spinBoxMaxHits );
        label->setBuddy( spinBoxMaxHits );
*/

        label = new TQLabel( i18n( "<qt>Use the same synatx as for <a href=\"http://www.math.tamu.edu/~comech/tools/bibget/\">BIBGET</a>. For spaces within a search element, use \"<tt>+</tt>\".<br/>Example: <tt>a=gilkey t=invariance book 1984</tt></qt>" ), this );
        vLayout->addWidget( label );

        vLayout->addStretch( 0 );

        connect( lineEditQuery, SIGNAL( returnPressed() ), this, SIGNAL( startSearch() ) );
        connect( lineEditQuery, SIGNAL( returnPressed( const TQString& ) ), completionQuery, SLOT( addItem( const TQString& ) ) );
    }

    WebQueryMathSciNet::WebQueryMathSciNet( TQWidget* parent ): WebQuery( parent )
    {
        m_widget = new WebQueryMathSciNetWidget( parent );
    }

    WebQueryMathSciNet::~WebQueryMathSciNet()
    {
        delete m_widget;
    }

    TQString WebQueryMathSciNet::title()
    {
        return i18n( "MathSciNet" );
    }

    TQString WebQueryMathSciNet::disclaimer()
    {
        return i18n( "American Mathematical Society" );
    }

    TQString WebQueryMathSciNet::disclaimerURL()
    {
        return "http://www.ams.org/ams/copyright.html";
    }

    WebQueryWidget *WebQueryMathSciNet::widget()
    {
        return m_widget;
    }

    void WebQueryMathSciNet::query()
    {
        WebQuery::query();
        Settings *settings = Settings::self();
        settings->setWebQueryDefault( "MathSciNet", m_widget->lineEditQuery->text() );

        setNumStages( 1 );

        TQStringList searchTerms = TQStringList::split( TQRegExp( "\\s+" ), m_widget->lineEditQuery->text().stripWhiteSpace() );
        if ( searchTerms.isEmpty() )
        {
            setEndSearch( WebQuery::statusInvalidQuery );
            return;
        }

        TQStringList queryTerms;
        int count = 1;
        for ( TQStringList::ConstIterator it = searchTerms.constBegin(); it != searchTerms.constEnd(); ++it )
        {
            const TQString term=*it;
            if ( term.startsWith( "a=" ) )
                queryTerms << TQString( "pg%1=AUCN" ).arg( count ) << TQString( "s%1=%2" ).arg( count ).arg( term.mid( 2 ) );
            else if ( term.startsWith( "t=" ) )
                queryTerms << TQString( "pg%1=TI" ).arg( count ) << TQString( "s%1=%2" ).arg( count ).arg( term.mid( 2 ) );
            else if ( term.startsWith( "k=" ) )
                queryTerms << TQString( "pg%1=ALLF" ).arg( count ) << TQString( "s%1=%2" ).arg( count ).arg( term.mid( 2 ) );
            else if ( term.startsWith( "r=" ) )
                queryTerms << TQString( "pg%1=MR" ).arg( count ) << TQString( "s%1=%2" ).arg( count ).arg( term.mid( 2 ) );
            else if ( term.startsWith( "j=" ) )
                queryTerms << TQString( "pg%1=JOUR" ).arg( count ) << TQString( "s%1=%2" ).arg( count ).arg( term.mid( 2 ) );
            else
                queryTerms << TQString( "pg%1=ALLF" ).arg( count ) << TQString( "s%1=%2" ).arg( count ).arg( term );
            ++count;
        }

        KURL url( TQString( "http://www.ams.org/msnmain?fn=130&fmt=bibtex&l=100&extend=1&" ).append( queryTerms.join( "&" ) ) );
        kdDebug()<<"url="<<url.prettyURL()<<endl;

        BibTeX::File *bibFile = downloadBibTeXFile( url );
        enterNextStage();

        if ( bibFile != NULL && !m_aborted )
        {
            for ( BibTeX::File::ElementList::iterator it = bibFile->begin(); it != bibFile->end(); ++it )
            {
                BibTeX::Entry *entry = dynamic_cast<BibTeX::Entry*>( *it );
                if ( entry != NULL )
                    emit foundEntry( entry, false );
            }
            setEndSearch( WebQuery::statusSuccess );
        }
        else if ( !m_aborted )
        {
            TQString message = TDEIO::NetAccess::lastErrorString();
            if ( message.isEmpty() )
                message.prepend( '\n' );
            message.prepend( TQString( i18n( "Querying database '%1' failed." ) ).arg( title() ) );
            KMessageBox::error( m_parent, message );
            setEndSearch( WebQuery::statusError );
        }
        else
            setEndSearch( WebQuery::statusAborted );

        if ( bibFile != NULL )
            delete bibFile;
    }

}
#include "webquerymathscinet.moc"
