/***************************************************************************
    copyright            : (C) 2006 by Robby Stephenson
    email                : robby@periapsis.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This file has been modified to match the requirements of KBibTeX.     *
 *   In case of problems or bugs arising from this implementation, please  *
 *   contact the KBibTeX team first.                                       *
 *                             Thomas Fischer <fischer@unix-ag.uni-kl.de>  *
 *                                                                         *
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of version 2 of the GNU General Public License as  *
 *   published by the Free Software Foundation;                            *
 *                                                                         *
 ***************************************************************************/

#ifndef KBIBTEX_ISO5426CONVERTER_H
#define KBIBTEX_ISO5426CONVERTER_H

class TQCString;
class TQString;
class TQChar;

#include <ntqglobal.h>

namespace KBibTeX {

/**
 * @author Robby Stephenson
 */
class Iso5426Converter {
public:
  static TQString toUtf8(const TQCString& text);

private:
  static bool hasNext(uint pos, uint len);
  static bool isAscii(uchar c);
  static bool isCombining(uchar c);

  static TQChar getChar(uchar c);
  static TQChar getCombiningChar(uint i);
};

} // end namespace

#endif
