/***************************************************************************
*   Copyright (C) 2004-2006 by Thomas Fischer                             *
*   fischer@unix-ag.uni-kl.de                                             *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/
#ifndef BIBTEXFILEEXPORTERRTF_H
#define BIBTEXFILEEXPORTERRTF_H

#include <fileexportertoolchain.h>

namespace BibTeX
{

    /**
    @author Thomas Fischer
    */
    class FileExporterRTF : public FileExporterToolchain
    {
    public:
        FileExporterRTF();
        ~FileExporterRTF();

        bool save( TQIODevice* iodevice, const File* bibtexfile, TQStringList *errorLog = NULL );
        bool save( TQIODevice* iodevice, const Element* element, TQStringList *errorLog = NULL );

        void setLaTeXLanguage( const TQString& language );
        void setLaTeXBibliographyStyle( const TQString& bibStyle );

    private:
        TQString laTeXFilename;
        TQString bibTeXFilename;
        TQString outputFilename;
        TQString m_latexLanguage;
        TQString m_latexBibStyle;

        bool generateRTF( TQIODevice* iodevice, TQStringList *errorLog );
        bool writeLatexFile( const TQString &filename );
    };

}

#endif
