/***************************************************************************
*   Copyright (C) 2004-2009 by Thomas Fischer                             *
*   fischer@unix-ag.uni-kl.de                                             *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/
#include <ntqlayout.h>
#include <ntqtextedit.h>
#include <ntqbuffer.h>

#include <kdialog.h>
#include <kpushbutton.h>
#include <tdelocale.h>
#include <tdeglobalsettings.h>

#include <fileexporterbibtex.h>
#include <fileimporterbibtex.h>
#include <entry.h>
#include <settings.h>
#include "entrywidgetsource.h"

namespace KBibTeX
{

    EntryWidgetSource::EntryWidgetSource( BibTeX::File *bibtexfile, bool isReadOnly, TQWidget *parent, const char *name )
            : EntryWidgetTab( bibtexfile, isReadOnly, parent, name ), m_entry( NULL )
    {
        setupGUI();
    }

    EntryWidgetSource::~EntryWidgetSource()
    {
        if ( m_entry != NULL ) delete m_entry;
    }

    bool EntryWidgetSource::isModified()
    {
        return m_textEditSource->isModified();
    }

    bool EntryWidgetSource::containsValidText()
    {
        BibTeX::Entry dummy( BibTeX::Entry::etArticle, "iaKWjDMVuB2vTQDuYRK49Y85tyxa9" );
        apply( &dummy );
        return dummy.id().compare( "iaKWjDMVuB2vTQDuYRK49Y85tyxa9" ) != 0;
    }

    TQString EntryWidgetSource::text()
    {
        return m_textEditSource->text();
    }

    void EntryWidgetSource::setText( const TQString& text )
    {
        m_textEditSource->setText( text );
    }

    void EntryWidgetSource::updateGUI( BibTeX::Entry::EntryType /*entryType*/, bool /*enableAll*/ )
    {
        // nothing
    }

    void EntryWidgetSource::apply( BibTeX::Entry *entry )
    {
        Settings * settings = Settings::self();
        TQBuffer buffer;
        BibTeX::FileImporterBibTeX importer( settings->editing_FirstNameFirst );

        buffer.open( IO_WriteOnly );
        TQTextStream ts( &buffer );
        ts.setEncoding( TQTextStream::UnicodeUTF8 );
        ts << m_textEditSource->text() << endl;
        buffer.close();

        buffer.open( IO_ReadOnly );
        BibTeX::File *bibtexFile = importer.load( &buffer );
        buffer.close();

        if ( bibtexFile != NULL )
        {
            if ( bibtexFile->count() == 1 )
            {
                BibTeX::Entry * parsedEntry = dynamic_cast<BibTeX::Entry*>( bibtexFile->at( 0 ) );
                if ( parsedEntry != NULL )
                {
                    entry->copyFrom( parsedEntry );
                    settings->addToCompletion( parsedEntry );
                }
            }
            delete bibtexFile;
        }
    }

    void EntryWidgetSource::reset( BibTeX::Entry *entry )
    {
        if ( m_entry != entry )
        {
            if ( m_entry != NULL ) m_entry->copyFrom( entry ); else m_entry = new BibTeX::Entry( entry );
        }

        Settings * settings = Settings::self();

        TQBuffer buffer;
        BibTeX::FileExporterBibTeX exporter;
        exporter.setEncoding( "latex" );
        exporter.setStringDelimiter( settings->fileIO_BibtexStringOpenDelimiter, settings->fileIO_BibtexStringCloseDelimiter );
        exporter.setKeywordCasing( settings->fileIO_KeywordCasing );
        exporter.setEnclosingCurlyBrackets( settings->fileIO_EnclosingCurlyBrackets );

        buffer.open( IO_WriteOnly );
        exporter.save( &buffer, entry );
        buffer.close();

        buffer.open( IO_ReadOnly );
        TQTextStream ts( &buffer );
        ts.setEncoding( TQTextStream::UnicodeUTF8 );
        m_textEditSource->setText( ts.read() );
        buffer.close();
    }

    void EntryWidgetSource::restore()
    {
        reset( m_entry );
    }

    void EntryWidgetSource::updateWarnings( BibTeX::Entry::EntryType /*entryType*/, TQListView * /*listViewWarnings*/ )
    {
        // nothing
    }

    void EntryWidgetSource::setupGUI()
    {
        TQGridLayout * gridLayout = new TQGridLayout( this, 2, 2, KDialog::marginHint(), KDialog::spacingHint(), "gridLayout" );
        gridLayout->setRowStretch( 0, 5 );
        gridLayout->setColStretch( 0, 5 );

        m_textEditSource = new TQTextEdit( this );
        gridLayout->addMultiCellWidget( m_textEditSource, 0, 0, 0, 1 );
        m_textEditSource->setFont( TDEGlobalSettings::fixedFont() );
        m_textEditSource->setReadOnly( m_isReadOnly );

        KPushButton *btnReset = new KPushButton( i18n( "Restore" ), this );
        gridLayout->addWidget( btnReset, 1, 1 );
        connect( btnReset, SIGNAL( clicked() ), this, SLOT( restore() ) );
    }

}
#include "entrywidgetsource.moc"
