/***************************************************************************
*   Copyright (C) 2004-2006 by Thomas Fischer                             *
*   fischer@unix-ag.uni-kl.de                                             *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/
#ifndef BIBTEXENCODERXML_H
#define BIBTEXENCODERXML_H

#include <ntqptrlist.h>
#include <ntqregexp.h>

#include <encoder.h>

class TQString;
class TQRegExp;

namespace BibTeX
{

    /**
    @author Thomas Fischer
    */
    class EncoderXML : public Encoder
    {
    public:
        EncoderXML();
        ~EncoderXML();

        TQString decode( const TQString &text );
        TQString encode( const TQString &text );
        TQString encodeSpecialized( const TQString &text, const EntryField::FieldType fieldType = EntryField::ftUnknown );

        static EncoderXML *currentEncoderXML();

    private:
        struct CharMappingItem
        {
            TQRegExp regExp;
            TQChar unicode;
            TQString latex;
        };

        TQValueList<CharMappingItem> m_charMapping;

        void buildCharMapping();
    };

}

#endif
