/***************************************************************************
                          databasebrowser.cpp  -  description
                             -------------------
    begin                : Mit Mai 15 2002
    copyright            : (C) 2002 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "databasebrowser.h"
#include "mydatatable.h"
#include "definition.h"
#include "sqltables.h"
#include "csvimportdlg.h"

// TQt includes
#include <tqclipboard.h>

// KDE includes
#include <tdeaction.h>
#include <tdeapplication.h>
#include <keditcl.h>
#include <tdelocale.h>
#include <tdemenubar.h>
#include <tdepopupmenu.h>
#include <kstatusbar.h>

#define CUR_TABLE_ID 6666

DatabaseBrowser::DatabaseBrowser( TQString _database, TQWidget *parent, const char *name )
    : DSMainWindow(parent,name)
{
    m_direction = m_case = false;

    table = new MyDataTable(this );
    setCentralWidget( table );

    statusBar()->insertItem( i18n("Current Table: <b>" ) + _database, CUR_TABLE_ID, 0, true );
    statusBar()->setSizeGripEnabled( true );
    statusBar()->show();

    database = _database;

    connect( table, TQT_SIGNAL( cursorChanged( TQSql::Op ) ),
             SqlTables::getInstance(), TQT_SIGNAL( tablesChanged() ) );

    connect( TQT_TQOBJECT(this), TQT_SIGNAL( connectedSQL() ), this, TQT_SLOT( setupSql() ) );

    findDlg = 0;
    
    setupActions();
    show();

    setupSql();
}

DatabaseBrowser::~DatabaseBrowser()
{
    // update sql label definitions
    // because they may have changed
    // TODO:
    // add selction here to only update
    // if neccessary!
    Definition::updateProducer();
    DSMainWindow::saveConfig();    

    if( findDlg )
        delete findDlg;
}

void DatabaseBrowser::setupActions()
{
    DSMainWindow::setupActions();
    TDEPopupMenu* editMenu = new TDEPopupMenu( this );

    TDEAction* acut = KStdAction::cut( TQT_TQOBJECT(this), TQT_SLOT( cut() ), actionCollection() );
    TDEAction* acopy = KStdAction::copy( TQT_TQOBJECT(this), TQT_SLOT( copy() ), actionCollection() );
    TDEAction* apaste = KStdAction::paste( TQT_TQOBJECT(this), TQT_SLOT( paste() ), actionCollection() );
    TDEAction* afind = KStdAction::find( TQT_TQOBJECT(this), TQT_SLOT( find() ), actionCollection() );
    menuBar()->insertItem( i18n("&Edit"), editMenu, -1, 1 );

    acut->plug( editMenu );
    acopy->plug( editMenu );
    apaste->plug( editMenu );
    
    editMenu->insertSeparator();
    afind->plug( editMenu );
    KStdAction::findNext( TQT_TQOBJECT(this), TQT_SLOT( findNext() ), actionCollection() )->plug( editMenu );
    editMenu->insertSeparator();
    TDEAction* aimport = new TDEAction( i18n("&Import CSV File..."), "",
                                0, TQT_TQOBJECT(this), TQT_SLOT(import()), actionCollection(), "import" );
    aimport->plug( editMenu );
        
    acut->plug( toolBar() );
    acopy->plug( toolBar() );
    apaste->plug( toolBar() );

    toolBar()->insertSeparator();
    afind->plug( toolBar() );

    DSMainWindow::loadConfig();
}

void DatabaseBrowser::setupSql()
{
    TQSqlCursor* cur = new TQSqlCursor( database, true );
    cur->select();
    unsigned int i = 0;
    unsigned int c = 0;
    while ( cur->next() ) {
        for( c = 0; c < cur->count(); c++ ) {
            table->setText( i, c, cur->value( c ).toString() );
            table->horizontalHeader()->setLabel( c, cur->fieldName( c ) );
        }
        i++;
    }

    table->setNumCols( c );
    table->setNumRows( i );

    table->setSqlCursor( cur, true, true );
    table->setSorting( true );
    table->setConfirmDelete( true );
    table->setAutoEdit( true );
    table->refresh( TQDataTable::RefreshAll );
}

void DatabaseBrowser::find()
{
    if( !findDlg )
        findDlg = new KEdFind( this, "findDlg", false );
        
    findDlg->setText( m_find );
    findDlg->setDirection( m_direction );
    findDlg->setCaseSensitive( m_case );
    connect( findDlg, TQT_SIGNAL( search() ), this, TQT_SLOT( findNext() ) );
    
    findDlg->exec();
    
}

void DatabaseBrowser::findNext()
{
    if( findDlg ) {
        m_find = findDlg->getText();
        m_direction = findDlg->get_direction();
        m_case = findDlg->case_sensitive();
    } else
        find();

    table->find( m_find, m_case, m_direction );
}

void DatabaseBrowser::cut()
{
    TQString text = table->value( table->currentRow(), table->currentColumn() ).toString();
    if( !text.isEmpty() ) {
        kapp->clipboard()->setText( text );

        TQSqlRecord* buffer = table->sqlCursor()->primeUpdate();
        if( buffer ) {
            buffer->setValue( table->horizontalHeader()->label( table->currentColumn() ), "" );
            table->sqlCursor()->update();
            table->refresh();
        }

    }
}

void DatabaseBrowser::copy()
{
    TQString text = table->value( table->currentRow(), table->currentColumn() ).toString();
    if( !text.isEmpty() )
        kapp->clipboard()->setText( text );
}

void DatabaseBrowser::paste()
{
    TQString text = kapp->clipboard()->text();
    if( !text.isEmpty() ) {
        TQSqlRecord* buffer = table->sqlCursor()->primeUpdate();
        if( buffer ) {
            buffer->setValue( table->horizontalHeader()->label( table->currentColumn() ), text );
            table->sqlCursor()->update();
            table->refresh();
        }
    }

}

void DatabaseBrowser::import()
{
    new CSVImportDlg( this );
}

#include "databasebrowser.moc"
