/***************************************************************************
                          barcodedialog.cpp  -  description
                             -------------------
    begin                : Son Dez 29 2002
    copyright            : (C) 2002 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "barcodedialog.h"
#include "barcodeitem.h"
#include "printersettings.h"
#include "barcodecombo.h"
#include "mimesources.h"
#include "tokenprovider.h"

// KDE includes
#include <tdeapplication.h>
#include <tdefiledialog.h>
#include <kiconloader.h>
#include <kimageio.h>
#include <tdelocale.h>
#include <tdemessagebox.h>
#include <kprinter.h>
#include <kpushbutton.h>

// TQt includes
#include <tqclipboard.h>
#include <tqlabel.h>
#include <tqlayout.h>
#include <tqpainter.h>
#include <tqpaintdevicemetrics.h>
#include <tqpicture.h>

BarCodeDialog::BarCodeDialog( TQWidget* parent,  const char* name )
    : TQDialog( parent, name, false)
{
    setCaption( i18n( "Barcode Generator" ) );

    BarCodeDialogLayout = new TQHBoxLayout( this, 11, 6, "BarCodeDialogLayout");
    Layout5 = new TQVBoxLayout( 0, 0, 6, "Layout5");
    Layout6 = new TQVBoxLayout( 0, 0, 6, "Layout2");
    widget = new BarcodeWidget( this, "widget" );

    m_token = new TokenProvider( TQT_TQPAINTDEVICE(TDEApplication::desktop()) );
    widget->setTokenProvider( m_token );

    buttonGenerate = new KPushButton( this, "buttonGenerate" );
    buttonGenerate->setText( i18n( "&Generate" ) );
    buttonGenerate->setEnabled( Barkode::haveBarcode() );
    buttonGenerate->setIconSet( SmallIconSet("barcode") );
    
    buttonSave = new KPushButton( this, "buttonSave" );
    buttonSave->setText( i18n( "&Save" ) );
    buttonSave->setEnabled( false );
    buttonSave->setIconSet( SmallIconSet("document-save") );
        
    buttonCopy = new KPushButton( this, "buttonCopy" );
    buttonCopy->setText( i18n("&Copy") );
    buttonCopy->setEnabled( false );
    buttonCopy->setIconSet( SmallIconSet("edit-copy") );
    
    buttonPrint = new KPushButton( this );
    buttonPrint->setText( i18n("&Print") );
    buttonPrint->setEnabled( false );
    buttonPrint->setIconSet( SmallIconSet("document-print") );
    
    buttonClose = new KPushButton( this );
    buttonClose->setText( i18n("&Close" ) );
    buttonClose->setIconSet( SmallIconSet("window-close") );
    

    TQScrollView* sv = new TQScrollView( this );
    
    barcode = new TQLabel( sv->viewport(), "barcode" );
    sv->addChild( barcode );
    connect( buttonGenerate, TQT_SIGNAL( clicked() ), this, TQT_SLOT( generate() ) );
    connect( buttonSave, TQT_SIGNAL( clicked() ), this, TQT_SLOT( save() ) );
    connect( buttonPrint, TQT_SIGNAL( clicked() ), this, TQT_SLOT( print() ) );
    connect( buttonCopy, TQT_SIGNAL( clicked() ), this, TQT_SLOT( copy() ) );

    TQSpacerItem* spacer = new TQSpacerItem( 20, 20, TQSizePolicy::Expanding, TQSizePolicy::Expanding );

    Layout5->addWidget( buttonGenerate );
    Layout5->addWidget( buttonSave );
    Layout5->addWidget( buttonPrint );
    Layout5->addWidget( buttonCopy );
    Layout5->addItem( spacer );
    Layout5->addWidget( buttonClose );
    
    Layout6->addWidget( widget );
    Layout6->addWidget( sv );
    
    BarCodeDialogLayout->addLayout( Layout6 );
    BarCodeDialogLayout->addLayout( Layout5 );
    BarCodeDialogLayout->setStretchFactor( Layout6, 2 );

    connect( buttonClose, TQT_SIGNAL( clicked() ), this, TQT_SLOT( close() ) );
    
    buttonGenerate->setDefault( true );
    
    show();
}

BarCodeDialog::~BarCodeDialog()
{
    delete m_token;
}

void BarCodeDialog::generate()
{        
    Barkode d;
    widget->getData( d );
    d.setTokenProvider( m_token );
    d.update( TQT_TQPAINTDEVICE(TDEApplication::desktop()) );

    barcode->setPixmap( d.pixmap() );

    buttonSave->setEnabled( !barcode->pixmap()->isNull() );
    buttonPrint->setEnabled( !barcode->pixmap()->isNull() );
    buttonCopy->setEnabled( !barcode->pixmap()->isNull() );
}

void BarCodeDialog::save()
{
    Barkode bc;
    widget->getData( bc );

    if(!bc.isValid()) 
    {
        KFileDialog fd( ":save_image", KImageIO::pattern( KImageIO::Writing ), this, "fd", true );
        fd.setMode( KFile::File );
        fd.setOperationMode( KFileDialog::Saving );       
        if( fd.exec() == TQDialog::Accepted ) 
        {
            TQString path = fd.selectedURL().path();
            TQString extension = KImageIO::type( path );
        
            if( extension.isNull() )
                extension = KImageIO::type( fd.currentFilter() ); 

        
            bc.setTokenProvider( m_token );
            bc.update( TQT_TQPAINTDEVICE(TDEApplication::desktop()) );

            if(!bc.pixmap().save( path, extension, 0 ))
                KMessageBox::error( this, i18n("An error occurred during saving the image") );
        }
    }        
}

void BarCodeDialog::print()
{
    Barkode d;
    widget->getData( d );
    
    if( d.isValid() )
        return;

    KPrinter* printer = PrinterSettings::getInstance()->setupPrinter( "kbarcode", this );
    if( !printer )
        return;

    // unless we can center the barcode
    printer->setFullPage( false );
    
    TQPaintDeviceMetrics metrics( printer );
    
    double scalex = (double)metrics.logicalDpiX() / (double)TQPaintDevice::x11AppDpiX();
    double scaley = (double)metrics.logicalDpiY() / (double)TQPaintDevice::x11AppDpiY();
    
    TQPicture picture;
    TQPainter p( printer );
    p.scale( scalex, scaley );
    // TODO: center barcode

    TokenProvider tp( printer );
    
    d.setTokenProvider( &tp );
    d.update( printer );

    picture = d.picture();
    p.drawPicture( TQPoint( 0, 0 ), picture );
    p.end();
    
    delete printer;
}

void BarCodeDialog::copy()
{
    if( barcode->pixmap()->isNull() )
        return;
        
    Barkode bc;
    widget->getData( bc );

    BarcodeItem* item = new BarcodeItem( bc );
    DocumentItemList list;
    list.append( item );
    DocumentItemDrag* drag = new DocumentItemDrag();
    drag->setDocumentItem( &list );

    kapp->clipboard()->setData( drag, TQClipboard::Clipboard );
}

#include "barcodedialog.moc"
