/***************************************************************************
                          mimesources.cpp  -  description
                             -------------------
    begin                : Son Sep 14 2003
    copyright            : (C) 2003 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "mimesources.h"
#include "mycanvasview.h"
#include "documentitem.h"
#include "commands.h"
#include "xmlutils.h"

#include <kcommand.h>

#include <tqbuffer.h>
#include <tqcstring.h>
#include <tqdom.h>

class DragCommand : public NewItemCommand {
    public:
        DragCommand( MyCanvasView* view, DocumentItem* doc_item )
            : NewItemCommand( view, i18n("Pasted Object") )
        {
            m_doc_item = doc_item;
        }
        
        void create()
        {
            m_object = m_doc_item;
        }
        
    private:
        DocumentItem* m_doc_item;
};



DocumentItemDrag::DocumentItemDrag( TQWidget* dragSource, const char* name )
    : TQStoredDrag( DocumentItemDrag::mimeType(), dragSource, name )
{
}

TQString DocumentItemDrag::mimeType()
{
    return "application/x-kbarcode-document-item";
}

void DocumentItemDrag::setDocumentItem( DocumentItemList* list )
{
    TQByteArray data;
    TQBuffer buffer( data );
    if( buffer.open( IO_WriteOnly ) )
    {
        TQDomDocument doc("KBarcodeClipboard");
        TQDomElement root = doc.createElement( "root" );
        doc.appendChild( root );
        
        XMLUtils xml;
        for( unsigned int i=0;i<list->count();i++)
        {
            DocumentItem* item = list->at( i );
            xml.writeXMLDocumentItem( &root, &item );
        }
                
        TQTextStream t( &buffer );
        doc.save( t, 0 );
        
        buffer.close();
        setEncodedData( data );    
    }
}

bool DocumentItemDrag::canDecode( TQMimeSource* e )
{
    return e->provides( DocumentItemDrag::mimeType() );
}

bool DocumentItemDrag::decode( TQMimeSource* mime, MyCanvasView* cv, TokenProvider* token, KCommandHistory* history )
{
    TQByteArray data = mime->encodedData( DocumentItemDrag::mimeType() );
    TQDomDocument doc( "KBarcodeClipboard" );
    if( !doc.setContent( data ) )
        return false;
    
    TQDomNode n = doc.documentElement();
    TQDomNodeList list = n.childNodes();
    KMacroCommand* commands = new KMacroCommand( i18n("Paste") );
    
    for( unsigned int i=0;i<list.length();i++)
    {
        TQDomNode n = list.item(i);
        
        TQDomElement e = n.toElement();
        if( !e.isNull() )
        {
            XMLUtils xml;
            DocumentItem* item = NULL;
            if( xml.readXMLDocumentItem( &e, &item, token ) )
            {            
                DragCommand* dc = new DragCommand( cv, item );
                dc->execute();
                commands->addCommand( dc );
            }
            else
            {
                delete commands;
                return false;
            }
        }
    }
    
    history->addCommand( commands, false );
        
    return true;
}


#include "mimesources.moc"
