/***************************************************************************
                          multilineeditdlg.h  -  description
                             -------------------
    begin                : Sam Jan 11 2003
    copyright            : (C) 2003 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MULTILINEEDITDLG_H
#define MULTILINEEDITDLG_H

#include <tqwidget.h>
#include "documentitem.h"

class TDEActionCollection;
class TDEToggleAction;
class TDEFontAction;
class TDEFontSizeAction;
class TDEToolBar;
class KSpell;
class KSpellConfig;
class DSTextEdit;
class TokenProvider;

class MultiLineEditor : public TQWidget {
    Q_OBJECT
  
    public:
        MultiLineEditor( TokenProvider* token, TQWidget *parent=0, const char *name=0);
        ~MultiLineEditor();
        TQString text();
        void setText( const TQString & t );
        
    private slots:
        void setupActions();
        void updateActions();
        void spellCheckDone(const TQString & buffer);

        void save();
        void updateFont();
        void updateCharFmt();
        void updateAligment();
        void formatColor();
        void checkSpelling();
        void setAlignLeft( bool yes );
        void setAlignRight( bool yes );
        void setAlignCenter( bool yes );
        void setAlignJustify( bool yes );               
        void insertNewField();
        
    protected:
        TokenProvider* m_token;

	DSTextEdit* editor;
        
        TDEActionCollection* ac;
        
        TDEToggleAction *action_bold;
        TDEToggleAction *action_italic;
        TDEToggleAction *action_underline;

        TDEFontAction *action_font;
        TDEFontSizeAction *action_font_size;

        TDEToggleAction *action_align_left;
        TDEToggleAction *action_align_right;
        TDEToggleAction *action_align_center;
        TDEToggleAction *action_align_justify;

        TDEToolBar* toolBar;
        TDEToolBar* tool2Bar;
        TDEToolBar* tool3Bar;

        KSpell* spell;
};

#endif
