/***************************************************************************
 *   Copyright (C) 2005 by Joe Ferris                                      *
 *   jferris@optimistictech.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#ifndef KATAPULTACTION_H
#define KATAPULTACTION_H

#include <tqstring.h>
#include <tqptrlist.h>

class TQPixmap;
class KatapultItem;

/**
@author Joe Ferris
*/
class KatapultAction {

public:
	virtual ~KatapultAction();
	
	virtual void execute(const KatapultItem *) const;
	virtual bool accepts(const KatapultItem *) const;
	virtual TQString text() const;
	virtual TQPixmap icon(int) const;
	
};

#endif
