/***************************************************************************
 *   Copyright (C) 2006  Jonathan Riddell                                  *
 *   jriddell@ubuntu.com                                                   *
 *                                                                         *
 *   Copyright (C) 2005  Tobi Vollebregt                                   *
 *   tobivollebregt@gmail.com                                              *
 *                                                                         *
 *   Copyright (C) 2005 by Joe Ferris                                      *
 *   jferris@optimistictech.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#ifndef SPELLCATALOG_H
#define SPELLCATALOG_H

#include <kgenericfactory.h>

#include <tqstring.h>

#include "spelling.h"
#include <katapultcatalog.h>

class TQWidget;

/**
@author Jonathan Riddell
 */
class SpellCatalog : public KatapultCatalog
{
	Q_OBJECT
  

	public:

		SpellCatalog(TQObject*, const char*, const TQStringList&);
		virtual ~SpellCatalog();

		virtual void readSettings(TDEConfigBase*);
		virtual void writeSettings(TDEConfigBase*);
		virtual TQWidget* configure();
		int triggerWordLength();

	protected:

		virtual void queryChanged();

	 private:
		bool accepts(const TQString&) const;

		TQString _triggerWord;

		Spelling _result; // The one result (there's always one).

		void reset();

        protected slots:
		void triggerWordChanged(const TQString& triggerWord);

};

#endif
